"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaPrivilegesRegion = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _simple_privilege_section = require("./simple_privilege_section");
var _space_aware_privilege_section = require("./space_aware_privilege_section");
var _transform_error_section = require("./transform_error_section");
var _collapsible_panel = require("../../collapsible_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class KibanaPrivilegesRegion extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "getForm", () => {
      const {
        kibanaPrivileges,
        role,
        spacesEnabled,
        canCustomizeSubFeaturePrivileges,
        spaces = [],
        uiCapabilities,
        onChange,
        editable,
        validator,
        spacesApiUi
      } = this.props;
      if (role._transform_error && role._transform_error.includes('kibana')) {
        return /*#__PURE__*/_react.default.createElement(_transform_error_section.TransformErrorSection, null);
      }
      if (spacesApiUi && spacesEnabled) {
        return /*#__PURE__*/_react.default.createElement(_space_aware_privilege_section.SpaceAwarePrivilegeSection, {
          kibanaPrivileges: kibanaPrivileges,
          role: role,
          spaces: spaces,
          uiCapabilities: uiCapabilities,
          onChange: onChange,
          editable: editable,
          canCustomizeSubFeaturePrivileges: canCustomizeSubFeaturePrivileges,
          validator: validator,
          spacesApiUi: spacesApiUi
        });
      }
      return /*#__PURE__*/_react.default.createElement(_simple_privilege_section.SimplePrivilegeSection, {
        kibanaPrivileges: kibanaPrivileges,
        role: role,
        onChange: onChange,
        editable: editable,
        canCustomizeSubFeaturePrivileges: canCustomizeSubFeaturePrivileges
      });
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_collapsible_panel.CollapsiblePanel, {
      iconType: 'logoKibana',
      title: 'Kibana'
    }, this.getForm());
  }
}
exports.KibanaPrivilegesRegion = KibanaPrivilegesRegion;