"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserProfile = exports.SaveChangesBottomBar = void 0;
exports.useUserProfileForm = useUserProfileForm;
var _eui = require("@elastic/eui");
var _formik = require("formik");
var _react = _interopRequireWildcard(require("react"));
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _userProfileComponents = require("@kbn/user-profile-components");
var _utils = require("./utils");
var _model = require("../../../common/model");
var _components = require("../../components");
var _breadcrumb = require("../../components/breadcrumb");
var _form_changes = require("../../components/form_changes");
var _form_field = require("../../components/form_field");
var _form_label = require("../../components/form_label");
var _form_row = require("../../components/form_row");
var _change_password_modal = require("../../management/users/edit_user/change_password_modal");
var _user_utils = require("../../management/users/user_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserDetailsEditor = ({
  user
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const canChangeDetails = (0, _model.canUserChangeDetails)(user, services.application.capabilities);
  if (!canChangeDetails) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.detailsGroupTitle",
      defaultMessage: "Details"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.detailsGroupDescription",
      defaultMessage: "Provide some basic information about yourself."
    })
  }, /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    label: /*#__PURE__*/_react.default.createElement(_form_label.FormLabel, {
      for: "user.full_name"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.fullNameLabel",
      defaultMessage: "Full name"
    })),
    labelAppend: /*#__PURE__*/_react.default.createElement(_form_row.OptionalText, null),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    name: "user.full_name",
    "data-test-subj": 'userProfileFullName',
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    label: /*#__PURE__*/_react.default.createElement(_form_label.FormLabel, {
      for: "user.email"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.emailLabel",
      defaultMessage: "Email address"
    })),
    labelAppend: /*#__PURE__*/_react.default.createElement(_form_row.OptionalText, null),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    type: "email",
    name: "user.email",
    "data-test-subj": 'userProfileEmail',
    fullWidth: true
  })));
};
const UserSettingsEditor = ({
  formik,
  isThemeOverridden,
  isOverriddenThemeDarkMode
}) => {
  if (!formik.values.data) {
    return null;
  }
  let idSelected = formik.values.data.userSettings.darkMode;
  if (isThemeOverridden) {
    if (isOverriddenThemeDarkMode) {
      idSelected = 'dark';
    } else {
      idSelected = 'light';
    }
  }
  const themeItem = ({
    id,
    label,
    icon
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
      name: id,
      label: label,
      "data-test-subj": `themeKeyPadItem${label}`,
      checkable: "single",
      isSelected: idSelected === id,
      isDisabled: isThemeOverridden,
      onChange: () => formik.setFieldValue('data.userSettings.darkMode', id)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: icon,
      size: "l"
    }));
  };
  const themeMenu = themeOverridden => {
    const themeKeyPadMenu = /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenu, {
      "aria-label": _i18n.i18n.translate('xpack.security.accountManagement.userProfile.userSettings.themeGroupDescription', {
        defaultMessage: 'Elastic theme'
      }),
      "data-test-subj": "themeMenu",
      checkable: {
        legend: /*#__PURE__*/_react.default.createElement(_form_label.FormLabel, {
          for: "data.userSettings.darkMode"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.accountManagement.userProfile.userSettings.theme",
          defaultMessage: "Mode"
        }))
      }
    }, themeItem({
      id: '',
      label: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.defaultModeButton', {
        defaultMessage: 'Space default'
      }),
      icon: 'spaces'
    }), themeItem({
      id: 'light',
      label: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.lightModeButton', {
        defaultMessage: 'Light'
      }),
      icon: 'sun'
    }), themeItem({
      id: 'dark',
      label: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.darkModeButton', {
        defaultMessage: 'Dark'
      }),
      icon: 'moon'
    }));
    return themeOverridden ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      "data-test-subj": "themeOverrideTooltip",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.accountManagement.userProfile.overriddenMessage",
        defaultMessage: "This setting is overridden by the Kibana server and can not be changed."
      })
    }, themeKeyPadMenu) : themeKeyPadMenu;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    fieldFlexItemProps: {
      style: {
        alignSelf: 'flex-start'
      }
    },
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.userSettingsTitle",
      defaultMessage: "Theme"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.themeFormGroupDescription",
      defaultMessage: "Select the appearance of your interface."
    })
  }, /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    name: "data.userSettings.darkMode",
    fullWidth: true
  }, themeMenu(isThemeOverridden)));
};
function UserAvatarEditor({
  user,
  formik
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!formik.values.data) {
    return null;
  }
  const isReservedUser = (0, _user_utils.isUserReserved)(user);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    fieldFlexItemProps: {
      style: {
        alignSelf: 'flex-start'
      }
    },
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.avatarGroupTitle",
      defaultMessage: "Avatar"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.avatarGroupDescription",
      defaultMessage: "Provide your initials or upload an image to represent yourself."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, formik.values.avatarType === 'image' && !formik.values.data.avatar.imageUrl ? /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
    size: "xl"
  }) : /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
    user: {
      username: user.username,
      full_name: formik.values.user.full_name
    },
    avatar: {
      imageUrl: formik.values.avatarType === 'image' ? formik.values.data.avatar.imageUrl : undefined,
      initials: formik.values.data.avatar.initials || '?',
      color: _utils.VALID_HEX_COLOR.test(formik.values.data.avatar.color) ? formik.values.data.avatar.color : undefined
    },
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    name: "avatarType",
    label: /*#__PURE__*/_react.default.createElement(_form_label.FormLabel, {
      for: "avatarType"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.avatarTypeGroupDescription",
      defaultMessage: "Avatar type"
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.avatarTypeGroupDescription', {
      defaultMessage: 'Avatar type'
    }),
    buttonSize: "m",
    idSelected: formik.values.avatarType,
    options: [{
      id: 'initials',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.accountManagement.userProfile.initialsAvatarTypeLabel",
        defaultMessage: "Initials"
      })
    }, {
      id: 'image',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.accountManagement.userProfile.imageAvatarTypeLabel",
        defaultMessage: "Image"
      }),
      iconType: 'image'
    }],
    onChange: id => formik.setFieldValue('avatarType', id),
    isFullWidth: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), formik.values.avatarType === 'image' ? /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    label: /*#__PURE__*/_react.default.createElement(_form_label.FormLabel, {
      for: "data.avatar.imageUrl"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.imageUrlLabel",
      defaultMessage: "Image"
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    as: _eui.EuiFilePicker,
    name: "data.avatar.imageUrl",
    value: undefined /* EuiFilePicker breaks if value is provided  */,
    initialPromptText: formik.values.data.avatar.imageUrl ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.prepopulatedImageUrlPromptText",
      defaultMessage: "Select or drag and drop a replacement image"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.imageUrlPromptText",
      defaultMessage: "Select or drag and drop an image"
    }),
    onChange: (0, _utils.createImageHandler)(imageUrl => {
      formik.setFieldValue('data.avatar.imageUrl', imageUrl !== null && imageUrl !== void 0 ? imageUrl : '');
    }),
    validate: {
      required: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.imageUrlRequiredError', {
        defaultMessage: 'Upload an image.'
      })
    },
    accept: _utils.IMAGE_FILE_TYPES.join(','),
    display: "default",
    fullWidth: true
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 64
    }
  }, /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    label: /*#__PURE__*/_react.default.createElement(_form_label.FormLabel, {
      for: "data.avatar.initials"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.initialsLabel",
      defaultMessage: "Initials"
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    name: "data.avatar.initials",
    maxLength: 2,
    validate: {
      required: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.initialsRequiredError', {
        defaultMessage: 'Add initials'
      }),
      maxLength: {
        value: 2,
        message: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.initialsMaxLengthError', {
          defaultMessage: 'Enter no more than 2 characters.'
        })
      }
    },
    fullWidth: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    label: /*#__PURE__*/_react.default.createElement(_form_label.FormLabel, {
      for: "data.avatar.color"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.colorLabel",
      defaultMessage: "Color"
    })),
    labelAppend: !isReservedUser ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => formik.setFieldValue('data.avatar.color', (0, _utils.getRandomColor)()),
      size: "xs",
      flush: "right",
      style: {
        height: euiTheme.base
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.randomizeButton",
      defaultMessage: "Randomize"
    })) : null,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    as: _eui.EuiColorPicker,
    name: "data.avatar.color",
    color: formik.values.data.avatar.color,
    validate: {
      required: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.colorRequiredError', {
        defaultMessage: 'Select a color.'
      }),
      pattern: {
        value: _utils.VALID_HEX_COLOR,
        message: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.colorPatternError', {
          defaultMessage: 'Enter a valid HEX color code.'
        })
      }
    },
    onChange: value => {
      formik.setFieldValue('data.avatar.color', value);
    },
    fullWidth: true
  })))));
}
function UserPasswordEditor({
  user,
  onShowPasswordForm
}) {
  const canChangePassword = (0, _model.canUserChangePassword)(user);
  if (!canChangePassword) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.passwordGroupTitle",
      defaultMessage: "Password"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.passwordGroupDescription",
      defaultMessage: "Protect your data with a strong password."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.passwordLabel",
      defaultMessage: "Password"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onShowPasswordForm,
    iconType: "lock",
    "data-test-subj": "openChangePasswordForm"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.userProfile.changePasswordButton",
    defaultMessage: "Change password"
  }))));
}
const UserRoles = ({
  user
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(isOpen => !isOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const [firstRole] = user.roles;
  const remainingRoles = user.roles.slice(1);
  const renderMoreRoles = () => {
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: onButtonClick,
      "data-test-subj": "userRolesExpand"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.rolesCountLabel",
      defaultMessage: "+{count} more",
      values: {
        count: remainingRoles.length
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      panelPaddingSize: "s",
      button: button,
      isOpen: isPopoverOpen,
      closePopover: closePopover,
      "data-test-subj": "userRolesPopover"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
      gutterSize: "xs",
      "data-test-subj": "remainingRoles",
      style: {
        maxWidth: '200px'
      }
    }, remainingRoles.map(role => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: role
    }, role))));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: euiTheme.breakpoint.m / 6,
      display: 'inline-block'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: firstRole,
    color: "hollow",
    "data-test-subj": `role${firstRole}`
  }, firstRole)), remainingRoles.length ? renderMoreRoles() : null);
};
const UserProfile = ({
  user,
  data
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services
  } = (0, _public.useKibana)();
  const formik = useUserProfileForm({
    user,
    data
  });
  const formChanges = (0, _form_changes.useFormChanges)();
  const titleId = (0, _eui.useGeneratedHtmlId)();
  const [showChangePasswordForm, setShowChangePasswordForm] = (0, _react.useState)(false);
  const canChangeDetails = (0, _model.canUserChangeDetails)(user, services.application.capabilities);
  const isCloudUser = user.elastic_cloud_user;
  const {
    isThemeOverridden,
    isOverriddenThemeDarkMode
  } = determineIfThemeOverridden(services.settings.client);
  const rightSideItems = [{
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.usernameLabel",
      defaultMessage: "Username"
    }),
    description: user.username,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.usernameHelpText",
      defaultMessage: "User name cannot be changed after account creation."
    }),
    testSubj: 'username'
  }];
  if (!canChangeDetails) {
    rightSideItems.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.accountManagement.userProfile.fullNameLabel",
        defaultMessage: "Full name"
      }),
      description: user.full_name,
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.accountManagement.userProfile.fullNameHelpText",
        defaultMessage: "Please contact an administrator to change your full name."
      }),
      testSubj: 'full_name'
    });
    rightSideItems.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.accountManagement.userProfile.emailLabel",
        defaultMessage: "Email address"
      }),
      description: user.email,
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.accountManagement.userProfile.emailHelpText",
        defaultMessage: "Please contact an administrator to change your email address."
      }),
      testSubj: 'email'
    });
  }
  rightSideItems.push({
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.rolesLabel",
      defaultMessage: "{roles, plural, one {Role} other {Roles} }",
      values: {
        roles: user.roles.length
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(UserRoles, {
      user: user
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.rolesHelpText",
      defaultMessage: "Roles control access and permissions across the Elastic Stack."
    }),
    testSubj: 'userRoles'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_formik.FormikProvider, {
    value: formik
  }, /*#__PURE__*/_react.default.createElement(_form_changes.FormChangesProvider, {
    value: formChanges
  }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
    text: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.title', {
      defaultMessage: 'Profile'
    })
  }, showChangePasswordForm ? /*#__PURE__*/_react.default.createElement(_change_password_modal.ChangePasswordModal, {
    username: user.username,
    onCancel: () => setShowChangePasswordForm(false),
    onSuccess: () => setShowChangePasswordForm(false)
  }) : null, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    className: "eui-fullHeight",
    restrictWidth: 1000
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.title",
      defaultMessage: "Profile"
    }),
    id: titleId,
    rightSideItems: rightSideItems.reverse().map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse",
      listItems: [{
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: euiTheme.colors.darkestShade,
          size: "s"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          responsive: false,
          alignItems: "center",
          gutterSize: "none"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, item.title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          style: {
            marginLeft: '0.33em'
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: "questionInCircle",
          content: item.helpText
        })))),
        description: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": item.testSubj
        }, item.description || /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: euiTheme.colors.disabledText,
          size: "s"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.accountManagement.userProfile.noneProvided",
          defaultMessage: "None provided"
        })))
      }],
      compressed: true
    }))
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_formik.Form, {
    "aria-labelledby": titleId
  }, /*#__PURE__*/_react.default.createElement(UserDetailsEditor, {
    user: user
  }), isCloudUser ? null : /*#__PURE__*/_react.default.createElement(UserAvatarEditor, {
    user: user,
    formik: formik
  }), /*#__PURE__*/_react.default.createElement(UserPasswordEditor, {
    user: user,
    onShowPasswordForm: () => setShowChangePasswordForm(true)
  }), isCloudUser ? null : /*#__PURE__*/_react.default.createElement(UserSettingsEditor, {
    formik: formik,
    isThemeOverridden: isThemeOverridden,
    isOverriddenThemeDarkMode: isOverriddenThemeDarkMode
  }))), formChanges.count > 0 ? /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, {
    paddingSize: "m",
    position: "fixed",
    "data-test-subj": 'userProfileBottomBar'
  }, /*#__PURE__*/_react.default.createElement(SaveChangesBottomBar, null)) : null)))));
};
exports.UserProfile = UserProfile;
function useUserProfileForm({
  user,
  data
}) {
  var _data$avatar, _data$avatar2, _data$avatar3, _data$userSettings, _data$avatar4, _data$avatar5, _data$avatar6, _formik$values$data;
  const {
    services
  } = (0, _public.useKibana)();
  const {
    users
  } = (0, _components.useSecurityApiClients)();
  const {
    update,
    showSuccessNotification
  } = (0, _userProfileComponents.useUpdateUserProfile)({
    notificationSuccess: {
      enabled: false
    }
  });
  const [initialValues, resetInitialValues] = (0, _react.useState)({
    user: {
      full_name: user.full_name || '',
      email: user.email || ''
    },
    data: data ? {
      avatar: {
        initials: ((_data$avatar = data.avatar) === null || _data$avatar === void 0 ? void 0 : _data$avatar.initials) || (0, _model.getUserAvatarInitials)(user),
        color: ((_data$avatar2 = data.avatar) === null || _data$avatar2 === void 0 ? void 0 : _data$avatar2.color) || (0, _model.getUserAvatarColor)(user),
        imageUrl: ((_data$avatar3 = data.avatar) === null || _data$avatar3 === void 0 ? void 0 : _data$avatar3.imageUrl) || ''
      },
      userSettings: {
        darkMode: ((_data$userSettings = data.userSettings) === null || _data$userSettings === void 0 ? void 0 : _data$userSettings.darkMode) || ''
      }
    } : undefined,
    avatarType: data !== null && data !== void 0 && (_data$avatar4 = data.avatar) !== null && _data$avatar4 !== void 0 && _data$avatar4.imageUrl ? 'image' : 'initials'
  });
  const [validateOnBlurOrChange, setValidateOnBlurOrChange] = (0, _react.useState)(false);
  const formik = (0, _formik.useFormik)({
    onSubmit: async values => {
      var _initialValues$data, _values$data;
      const submitActions = [];
      if ((0, _model.canUserChangeDetails)(user, services.application.capabilities)) {
        submitActions.push(users.saveUser({
          username: user.username,
          roles: user.roles,
          enabled: user.enabled,
          full_name: values.user.full_name,
          email: values.user.email
        }));
      }

      // Update profile only if it's available for the current user.
      if (values.data) {
        submitActions.push(update(values.avatarType === 'image' ? values.data : {
          ...values.data,
          avatar: {
            ...values.data.avatar,
            imageUrl: null
          }
        }));
      }
      if (submitActions.length === 0) {
        return;
      }
      try {
        await Promise.all(submitActions);
      } catch (error) {
        services.notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.submitErrorTitle', {
            defaultMessage: "Couldn't update profile"
          })
        });
        return;
      }
      resetInitialValues(values);
      let isRefreshRequired = false;
      if (((_initialValues$data = initialValues.data) === null || _initialValues$data === void 0 ? void 0 : _initialValues$data.userSettings.darkMode) !== ((_values$data = values.data) === null || _values$data === void 0 ? void 0 : _values$data.userSettings.darkMode)) {
        isRefreshRequired = true;
      }
      showSuccessNotification({
        isRefreshRequired
      });
    },
    initialValues,
    enableReinitialize: true,
    validateOnBlur: validateOnBlurOrChange,
    validateOnChange: validateOnBlurOrChange
  });

  // We perform _the first_ validation only when the user submits the form to make UX less annoying. But after the user
  // submits the form, the validation model changes to on blur/change (as the user's mindset has changed from completing
  // the form to correcting the form).
  if (formik.submitCount > 0 && !validateOnBlurOrChange) {
    setValidateOnBlurOrChange(true);
  } else if (formik.submitCount === 0 && validateOnBlurOrChange) {
    setValidateOnBlurOrChange(false);
  }
  const customAvatarInitials = (0, _react.useRef)(!!(data !== null && data !== void 0 && (_data$avatar5 = data.avatar) !== null && _data$avatar5 !== void 0 && _data$avatar5.initials) && ((_data$avatar6 = data.avatar) === null || _data$avatar6 === void 0 ? void 0 : _data$avatar6.initials) !== (0, _model.getUserAvatarInitials)(user));
  (0, _useUpdateEffect.default)(() => {
    if (!customAvatarInitials.current) {
      const defaultInitials = (0, _model.getUserAvatarInitials)({
        username: user.username,
        full_name: formik.values.user.full_name
      });
      formik.setFieldValue('data.avatar.initials', defaultInitials);
    }
  }, [formik.values.user.full_name]);
  (0, _useUpdateEffect.default)(() => {
    if (!customAvatarInitials.current && formik.values.data) {
      const defaultInitials = (0, _model.getUserAvatarInitials)({
        username: user.username,
        full_name: formik.values.user.full_name
      });
      customAvatarInitials.current = formik.values.data.avatar.initials !== defaultInitials;
    }
  }, [(_formik$values$data = formik.values.data) === null || _formik$values$data === void 0 ? void 0 : _formik$values$data.avatar.initials]);
  return formik;
}
const SaveChangesBottomBar = () => {
  const formik = (0, _formik.useFormikContext)();
  const {
    count
  } = (0, _form_changes.useFormChangesContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: {
      width: '100%'
    },
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "dot",
    color: "success"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.userProfile.unsavedChangesMessage",
    defaultMessage: "{count, plural, one {# unsaved change} other {# unsaved changes}}",
    values: {
      count
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: formik.handleReset,
    color: "text"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.userProfile.discardChangesButton",
    defaultMessage: "Discard"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: formik.submitForm,
    "data-test-subj": "saveProfileChangesButton",
    isLoading: formik.isSubmitting,
    isDisabled: formik.submitCount > 0 && !formik.isValid,
    color: "success",
    iconType: "save",
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.userProfile.saveChangesButton",
    defaultMessage: "{isSubmitting, select, true{Saving changes\u2026} other{Save changes}}",
    values: {
      isSubmitting: formik.isSubmitting
    }
  }))));
};
exports.SaveChangesBottomBar = SaveChangesBottomBar;
function determineIfThemeOverridden(settingsClient) {
  return {
    isThemeOverridden: settingsClient.isOverridden('theme:darkMode'),
    isOverriddenThemeDarkMode: settingsClient.get('theme:darkMode')
  };
}