"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseContext = exports.ConnectorConfigurationComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _util = require("react-use/lib/util");
var _connector_configuration_utils = require("../../utils/connector_configuration_utils");
var _ = require("../..");
var _connector_configuration_form = require("./connector_configuration_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function entryToDisplaylistItem(entry) {
  return {
    description: entry.sensitive && !!entry.value ? '********' : String(entry.value) || '--',
    title: entry.label
  };
}
const LicenseContext = /*#__PURE__*/(0, _react.createContext)({
  hasPlatinumLicense: false,
  subscriptionLink: undefined,
  stackManagementLink: undefined
});
exports.LicenseContext = LicenseContext;
const ConnectorConfigurationComponent = ({
  children,
  connector,
  hasPlatinumLicense,
  isLoading,
  saveConfig,
  subscriptionLink,
  stackManagementLink
}) => {
  var _features$FeatureName;
  const configurationRef = (0, _react.useRef)({});
  const {
    configuration,
    error,
    status: connectorStatus,
    is_native: isNative,
    features
  } = connector;
  const hasDocumentLevelSecurity = Boolean(features === null || features === void 0 ? void 0 : (_features$FeatureName = features[_.FeatureName.DOCUMENT_LEVEL_SECURITY]) === null || _features$FeatureName === void 0 ? void 0 : _features$FeatureName.enabled);
  const [isEditing, setIsEditing] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (!(0, _util.isDeepEqual)(configuration, configurationRef.current)) {
      configurationRef.current = configuration;
      setIsEditing(false);
    }
  }, [configuration]);
  (0, _react.useEffect)(() => {
    if (Object.keys(configuration || {}).length > 0 && (connectorStatus === _.ConnectorStatus.CREATED || connectorStatus === _.ConnectorStatus.NEEDS_CONFIGURATION)) {
      // Only start in edit mode if we haven't configured yet
      // Necessary to prevent a race condition between saving config and getting updated connector
      setIsEditing(true);
    }
  }, [configuration, connectorStatus]);
  const configView = (0, _connector_configuration_utils.sortAndFilterConnectorConfiguration)(configuration, isNative);
  const uncategorizedDisplayList = configView.unCategorizedItems.map(entryToDisplaylistItem);
  return /*#__PURE__*/_react.default.createElement(LicenseContext.Provider, {
    value: {
      hasPlatinumLicense,
      stackManagementLink,
      subscriptionLink
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, children && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isEditing ? /*#__PURE__*/_react.default.createElement(_connector_configuration_form.ConnectorConfigurationForm, {
    cancelEditing: () => setIsEditing(false),
    configuration: configuration,
    hasDocumentLevelSecurity: hasDocumentLevelSecurity,
    isLoading: isLoading,
    isNative: isNative,
    saveConfig: config => {
      saveConfig(config);
      setIsEditing(false);
    }
  }) : uncategorizedDisplayList.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: uncategorizedDisplayList,
    className: "eui-textBreakWord"
  })), configView.categories.length > 0 && configView.categories.map(category => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    key: category.key
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, category.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: category.configEntries.map(entryToDisplaylistItem),
    className: "eui-textBreakWord"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connector-configuration-editConfiguration",
    "data-telemetry-id": "entSearchContent-connector-overview-configuration-editConfiguration",
    onClick: () => setIsEditing(!isEditing)
  }, _i18n.i18n.translate('searchConnectors.configurationConnector.config.editButton.title', {
    defaultMessage: 'Edit configuration'
  }))))))), !!error && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: _i18n.i18n.translate('searchConnectors.configurationConnector.config.error.title', {
      defaultMessage: 'Connector error'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, error)))));
};
exports.ConnectorConfigurationComponent = ConnectorConfigurationComponent;