"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectSaveModalOrigin = SavedObjectSaveModalOrigin;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function SavedObjectSaveModalOrigin(props) {
  const [returnToOriginMode, setReturnToOriginMode] = (0, _react.useState)(Boolean(props.originatingApp));
  const {
    documentInfo
  } = props;
  const returnLabel = _i18n.i18n.translate('savedObjects.saveModalOrigin.returnToOriginLabel', {
    defaultMessage: 'Return'
  });
  const addLabel = _i18n.i18n.translate('savedObjects.saveModalOrigin.addToOriginLabel', {
    defaultMessage: 'Add'
  });
  const getReturnToOriginSwitch = state => {
    const sourceOptions = typeof props.options === 'function' ? props.options(state) : props.options;
    if (!props.originatingApp) {
      return sourceOptions;
    }
    const origin = props.getAppNameFromId ? props.getAppNameFromId(props.originatingApp) || props.originatingApp : props.originatingApp;
    if (!state.copyOnSave || props.originatingApp === 'dashboards' // dashboard supports adding a copied panel on save...
    ) {
      var _props$returnToOrigin;
      const originVerb = !documentInfo.id || state.copyOnSave ? addLabel : returnLabel;
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, sourceOptions, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        "data-test-subj": "returnToOriginModeSwitch",
        checked: returnToOriginMode,
        onChange: event => {
          setReturnToOriginMode(event.target.checked);
        },
        label: (_props$returnToOrigin = props.returnToOriginSwitchLabel) !== null && _props$returnToOrigin !== void 0 ? _props$returnToOrigin : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModalOrigin.originAfterSavingSwitchLabel",
          defaultMessage: "{originVerb} to {origin} after saving",
          values: {
            originVerb,
            origin
          }
        })
      })));
    } else {
      setReturnToOriginMode(false);
      return sourceOptions;
    }
  };
  const onModalSave = onSaveProps => {
    props.onSave({
      ...onSaveProps,
      returnToOrigin: returnToOriginMode
    });
  };
  const confirmButtonLabel = returnToOriginMode ? _i18n.i18n.translate('savedObjects.saveModalOrigin.saveAndReturnLabel', {
    defaultMessage: 'Save and return'
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_.SavedObjectSaveModal, {
    onSave: onModalSave,
    onClose: props.onClose,
    title: documentInfo.title,
    showCopyOnSave: documentInfo.id ? true : false,
    initialCopyOnSave: Boolean(documentInfo.id) && returnToOriginMode,
    confirmButtonLabel: confirmButtonLabel,
    objectType: props.objectType,
    options: getReturnToOriginSwitch,
    description: documentInfo.description,
    showDescription: true
  });
}