"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _lib = require("../lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
let allowedObjectTypes;
const title = _i18n.i18n.translate('savedObjectsManagement.objects.savedObjectsTitle', {
  defaultMessage: 'Saved Objects'
});
const SavedObjectsEditionPage = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./saved_objects_edition_page'))));
const SavedObjectsTablePage = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./saved_objects_table_page'))));
const mountManagementSection = async ({
  core,
  mountParams
}) => {
  const [coreStart, {
    data,
    dataViews,
    savedObjectsTaggingOss,
    spaces: spacesApi
  }, pluginStart] = await core.getStartServices();
  const {
    capabilities
  } = coreStart.application;
  const {
    element,
    history,
    setBreadcrumbs
  } = mountParams;
  const {
    theme$
  } = core.theme;
  if (!allowedObjectTypes) {
    allowedObjectTypes = await (0, _lib.getAllowedTypes)(coreStart.http);
  }
  coreStart.chrome.docTitle.change(title);
  const RedirectToHomeIfUnauthorized = ({
    children
  }) => {
    var _capabilities$managem, _capabilities$managem2, _capabilities$managem3;
    const allowed = (_capabilities$managem = capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$managem2 = capabilities.management) === null || _capabilities$managem2 === void 0 ? void 0 : (_capabilities$managem3 = _capabilities$managem2.kibana) === null || _capabilities$managem3 === void 0 ? void 0 : _capabilities$managem3.objects) !== null && _capabilities$managem !== void 0 ? _capabilities$managem : false;
    if (!allowed) {
      coreStart.application.navigateToApp('home');
      return null;
    }
    return children;
  };
  _reactDom.default.render((0, _public.wrapWithTheme)( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/:type/:id',
    exact: true
  }, /*#__PURE__*/_react.default.createElement(RedirectToHomeIfUnauthorized, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(SavedObjectsEditionPage, {
    coreStart: coreStart,
    setBreadcrumbs: setBreadcrumbs,
    history: history
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/',
    exact: false
  }, /*#__PURE__*/_react.default.createElement(RedirectToHomeIfUnauthorized, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(SavedObjectsTablePage, {
    coreStart: coreStart,
    taggingApi: savedObjectsTaggingOss === null || savedObjectsTaggingOss === void 0 ? void 0 : savedObjectsTaggingOss.getTaggingApi(),
    spacesApi: spacesApi,
    dataStart: data,
    dataViewsApi: dataViews,
    actionRegistry: pluginStart.actions,
    columnRegistry: pluginStart.columns,
    allowedTypes: allowedObjectTypes,
    setBreadcrumbs: setBreadcrumbs
  }))))))), theme$), element);
  return () => {
    coreStart.chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.mountManagementSection = mountManagementSection;