"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = exports.TIMESTAMP = exports.SPACE_IDS = exports.KIBANA_NAMESPACE = exports.ALERT_WORKFLOW_TAGS = exports.ALERT_WORKFLOW_STATUS = exports.ALERT_WORKFLOW_ASSIGNEE_IDS = exports.ALERT_UUID = exports.ALERT_URL = exports.ALERT_TIME_RANGE = exports.ALERT_STATUS = exports.ALERT_START = exports.ALERT_RULE_UUID = exports.ALERT_RULE_TYPE_ID = exports.ALERT_RULE_TAGS = exports.ALERT_RULE_REVISION = exports.ALERT_RULE_PRODUCER = exports.ALERT_RULE_PARAMETERS = exports.ALERT_RULE_NAMESPACE = exports.ALERT_RULE_NAME = exports.ALERT_RULE_EXECUTION_UUID = exports.ALERT_RULE_CONSUMER = exports.ALERT_RULE_CATEGORY = exports.ALERT_REASON = exports.ALERT_NAMESPACE = exports.ALERT_MAINTENANCE_WINDOW_IDS = exports.ALERT_LAST_DETECTED = exports.ALERT_INSTANCE_ID = exports.ALERT_FLAPPING_HISTORY = exports.ALERT_FLAPPING = exports.ALERT_END = exports.ALERT_DURATION = exports.ALERT_CASE_IDS = exports.ALERT_ACTION_GROUP = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TIMESTAMP = '@timestamp';

// namespaces
exports.TIMESTAMP = TIMESTAMP;
const KIBANA_NAMESPACE = 'kibana';
exports.KIBANA_NAMESPACE = KIBANA_NAMESPACE;
const ALERT_NAMESPACE = `${KIBANA_NAMESPACE}.alert`;
exports.ALERT_NAMESPACE = ALERT_NAMESPACE;
const ALERT_RULE_NAMESPACE = `${ALERT_NAMESPACE}.rule`;

// kibana.space_ids - space ID(s) of the rule that created this alert
exports.ALERT_RULE_NAMESPACE = ALERT_RULE_NAMESPACE;
const SPACE_IDS = `${KIBANA_NAMESPACE}.space_ids`;

// kibana.version - Kibana version that this alert was created
exports.SPACE_IDS = SPACE_IDS;
const VERSION = `${KIBANA_NAMESPACE}.version`;

// kibana.alert.action_group - framework action group ID for this alert
exports.VERSION = VERSION;
const ALERT_ACTION_GROUP = `${ALERT_NAMESPACE}.action_group`;

// kibana.alert.case_ids - array of cases associated with the alert
exports.ALERT_ACTION_GROUP = ALERT_ACTION_GROUP;
const ALERT_CASE_IDS = `${ALERT_NAMESPACE}.case_ids`;

// kibana.alert.duration.us - alert duration in microseconds - updated each execution
// that the alert is active
exports.ALERT_CASE_IDS = ALERT_CASE_IDS;
const ALERT_DURATION = `${ALERT_NAMESPACE}.duration.us`;

// kibana.alert.end - timestamp when the alert is auto-recovered by the framework
exports.ALERT_DURATION = ALERT_DURATION;
const ALERT_END = `${ALERT_NAMESPACE}.end`;

// kibana.alert.flapping - whether the alert is currently in a flapping state
exports.ALERT_END = ALERT_END;
const ALERT_FLAPPING = `${ALERT_NAMESPACE}.flapping`;

// kibana.alert.flapping_history - whether the alert is currently in a flapping state
exports.ALERT_FLAPPING = ALERT_FLAPPING;
const ALERT_FLAPPING_HISTORY = `${ALERT_NAMESPACE}.flapping_history`;

// kibana.alert.maintenance_window_ids - IDs of maintenance windows that are affecting this alert
exports.ALERT_FLAPPING_HISTORY = ALERT_FLAPPING_HISTORY;
const ALERT_MAINTENANCE_WINDOW_IDS = `${ALERT_NAMESPACE}.maintenance_window_ids`;

// kibana.alert.instance.id - alert ID, also known as alert instance ID
exports.ALERT_MAINTENANCE_WINDOW_IDS = ALERT_MAINTENANCE_WINDOW_IDS;
const ALERT_INSTANCE_ID = `${ALERT_NAMESPACE}.instance.id`;

// kibana.alert.last_detected - timestamp when the alert was last seen
exports.ALERT_INSTANCE_ID = ALERT_INSTANCE_ID;
const ALERT_LAST_DETECTED = `${ALERT_NAMESPACE}.last_detected`;

// kibana.alert.reason - human readable reason that this alert is active
exports.ALERT_LAST_DETECTED = ALERT_LAST_DETECTED;
const ALERT_REASON = `${ALERT_NAMESPACE}.reason`;

// kibana.alert.start - timestamp when the alert is first active
exports.ALERT_REASON = ALERT_REASON;
const ALERT_START = `${ALERT_NAMESPACE}.start`;

// kibana.alert.status - active/recovered status of alert
exports.ALERT_START = ALERT_START;
const ALERT_STATUS = `${ALERT_NAMESPACE}.status`;

// kibana.alert.time_range - time range of alert from kibana.alert.start to now
exports.ALERT_STATUS = ALERT_STATUS;
const ALERT_TIME_RANGE = `${ALERT_NAMESPACE}.time_range`;

// kibana.alert.uuid - unique ID for the active span of this alert
exports.ALERT_TIME_RANGE = ALERT_TIME_RANGE;
const ALERT_UUID = `${ALERT_NAMESPACE}.uuid`;

// kibana.alert.workflow_status - open/closed status of alert
exports.ALERT_UUID = ALERT_UUID;
const ALERT_WORKFLOW_STATUS = `${ALERT_NAMESPACE}.workflow_status`;

// kibana.alert.workflow_tags - user workflow alert tags
exports.ALERT_WORKFLOW_STATUS = ALERT_WORKFLOW_STATUS;
const ALERT_WORKFLOW_TAGS = `${ALERT_NAMESPACE}.workflow_tags`;

// kibana.alert.workflow_assignee_ids - user workflow alert assignees
exports.ALERT_WORKFLOW_TAGS = ALERT_WORKFLOW_TAGS;
const ALERT_WORKFLOW_ASSIGNEE_IDS = `${ALERT_NAMESPACE}.workflow_assignee_ids`;

// kibana.alert.rule.category - rule type name for rule that generated this alert
exports.ALERT_WORKFLOW_ASSIGNEE_IDS = ALERT_WORKFLOW_ASSIGNEE_IDS;
const ALERT_RULE_CATEGORY = `${ALERT_RULE_NAMESPACE}.category`;

// kibana.alert.rule.consumer - consumer for rule that generated this alert
exports.ALERT_RULE_CATEGORY = ALERT_RULE_CATEGORY;
const ALERT_RULE_CONSUMER = `${ALERT_RULE_NAMESPACE}.consumer`;

// kibana.alert.rule.execution.uuid - unique ID for the rule execution that generated this alert
exports.ALERT_RULE_CONSUMER = ALERT_RULE_CONSUMER;
const ALERT_RULE_EXECUTION_UUID = `${ALERT_RULE_NAMESPACE}.execution.uuid`;

// kibana.alert.rule.name - rule name for rule that generated this alert
exports.ALERT_RULE_EXECUTION_UUID = ALERT_RULE_EXECUTION_UUID;
const ALERT_RULE_NAME = `${ALERT_RULE_NAMESPACE}.name`;

// kibana.alert.rule.parameters - rule parameters for rule that generated this alert
exports.ALERT_RULE_NAME = ALERT_RULE_NAME;
const ALERT_RULE_PARAMETERS = `${ALERT_RULE_NAMESPACE}.parameters`;

// kibana.alert.rule.producer - rule type producer for rule that generated this alert
exports.ALERT_RULE_PARAMETERS = ALERT_RULE_PARAMETERS;
const ALERT_RULE_PRODUCER = `${ALERT_RULE_NAMESPACE}.producer`;

// kibana.alert.rule.revision - current revision of the rule that generated this alert
exports.ALERT_RULE_PRODUCER = ALERT_RULE_PRODUCER;
const ALERT_RULE_REVISION = `${ALERT_RULE_NAMESPACE}.revision`;

// kibana.alert.rule.tags - rule tags for rule that generated this alert
exports.ALERT_RULE_REVISION = ALERT_RULE_REVISION;
const ALERT_RULE_TAGS = `${ALERT_RULE_NAMESPACE}.tags`;

// kibana.alert.rule_type_id - rule type id for rule that generated this alert
exports.ALERT_RULE_TAGS = ALERT_RULE_TAGS;
const ALERT_RULE_TYPE_ID = `${ALERT_RULE_NAMESPACE}.rule_type_id`;

// kibana.alert.url - url which will redirect users to a page related to the given alert
exports.ALERT_RULE_TYPE_ID = ALERT_RULE_TYPE_ID;
const ALERT_URL = `${ALERT_NAMESPACE}.url`;

// kibana.alert.rule.uuid - rule ID for rule that generated this alert
exports.ALERT_URL = ALERT_URL;
const ALERT_RULE_UUID = `${ALERT_RULE_NAMESPACE}.uuid`;
exports.ALERT_RULE_UUID = ALERT_RULE_UUID;
const namespaces = {
  KIBANA_NAMESPACE,
  ALERT_NAMESPACE,
  ALERT_RULE_NAMESPACE
};
const fields = {
  ALERT_ACTION_GROUP,
  ALERT_CASE_IDS,
  ALERT_DURATION,
  ALERT_END,
  ALERT_FLAPPING,
  ALERT_FLAPPING_HISTORY,
  ALERT_MAINTENANCE_WINDOW_IDS,
  ALERT_INSTANCE_ID,
  ALERT_LAST_DETECTED,
  ALERT_REASON,
  ALERT_RULE_CATEGORY,
  ALERT_RULE_CONSUMER,
  ALERT_RULE_EXECUTION_UUID,
  ALERT_RULE_NAME,
  ALERT_RULE_PARAMETERS,
  ALERT_RULE_PRODUCER,
  ALERT_RULE_REVISION,
  ALERT_RULE_TAGS,
  ALERT_RULE_TYPE_ID,
  ALERT_RULE_UUID,
  ALERT_START,
  ALERT_STATUS,
  ALERT_TIME_RANGE,
  ALERT_URL,
  ALERT_UUID,
  ALERT_WORKFLOW_ASSIGNEE_IDS,
  ALERT_WORKFLOW_STATUS,
  ALERT_WORKFLOW_TAGS,
  SPACE_IDS,
  TIMESTAMP,
  VERSION
};