"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RollupPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _extend_index_management = require("./extend_index_management");
var _common = require("../common");
var _services = require("./crud_app/services");
var _kibana_services = require("./kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class RollupPlugin {
  constructor(ctx) {
    this.ctx = ctx;
  }
  setup(core, {
    home,
    management,
    indexManagement,
    usageCollection,
    dataViews
  }) {
    const {
      ui: {
        enabled: isRollupUiEnabled
      }
    } = this.ctx.config.get();
    (0, _kibana_services.setFatalErrors)(core.fatalErrors);
    if (usageCollection) {
      (0, _kibana_services.setUiStatsReporter)(usageCollection.reportUiCounter.bind(usageCollection, _common.UIM_APP_NAME));
    }
    if (isRollupUiEnabled) {
      if (indexManagement) {
        indexManagement.extensionsService.addBadge(_extend_index_management.rollupBadgeExtension);
        indexManagement.extensionsService.addToggle(_extend_index_management.rollupToggleExtension);
      }
      if (home) {
        home.featureCatalogue.register({
          id: 'rollup_jobs',
          title: 'Rollups',
          description: _i18n.i18n.translate('xpack.rollupJobs.featureCatalogueDescription', {
            defaultMessage: 'Summarize and store historical data in a smaller index for future analysis.'
          }),
          icon: 'indexRollupApp',
          path: `/app/management/data/rollup_jobs/job_list`,
          showOnHomePage: false,
          category: 'admin'
        });
      }
      dataViews.enableRollups();
      const pluginName = _i18n.i18n.translate('xpack.rollupJobs.appTitle', {
        defaultMessage: 'Rollup Jobs'
      });
      management.sections.section.data.registerApp({
        id: 'rollup_jobs',
        title: pluginName,
        order: 4,
        async mount(params) {
          const [coreStart] = await core.getStartServices();
          const {
            chrome: {
              docTitle
            }
          } = coreStart;
          docTitle.change(pluginName);
          params.setBreadcrumbs([{
            text: pluginName
          }]);
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          const unmountAppCallback = await renderApp(core, params);
          return () => {
            docTitle.reset();
            unmountAppCallback();
          };
        }
      });
    }
  }
  start(core) {
    (0, _services.setHttp)(core.http);
    (0, _kibana_services.setNotifications)(core.notifications);
    (0, _services.init)(core.docLinks);
  }
}
exports.RollupPlugin = RollupPlugin;