"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldChooser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FieldChooser extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onSearch", e => {
      this.setState({
        searchValue: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState(state => ({
        isOpen: !state.isOpen
      }));
    });
    (0, _defineProperty2.default)(this, "close", () => {
      this.setState({
        isOpen: false
      });
    });
    this.state = {
      isOpen: false,
      searchValue: ''
    };
  }
  render() {
    const {
      buttonLabel,
      columns,
      fields,
      selectedFields,
      prompt,
      onSelectField,
      dataTestSubj
    } = this.props;
    const {
      isOpen,
      searchValue
    } = this.state;
    const getRowProps = item => {
      return {
        onClick: () => {
          onSelectField(item);
        }
      };
    };
    const renderFlyout = () => {
      // Derive the fields which the user can select.
      const selectedFieldNames = selectedFields.map(({
        name
      }) => name);
      const unselectedFields = fields.filter(({
        name
      }) => {
        return !selectedFieldNames.includes(name);
      });
      const searchedItems = searchValue ? unselectedFields.filter(item => {
        const normalizedSearchValue = searchValue.trim().toLowerCase();
        return item.name.toLowerCase().includes(normalizedSearchValue) || item.type.toLowerCase().includes(normalizedSearchValue);
      }) : unselectedFields;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
        onClose: this.close,
        "aria-labelledby": "fieldChooserFlyoutTitle",
        size: "m",
        maxWidth: 400,
        "data-test-subj": dataTestSubj
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "m",
        id: "fieldChooserFlyoutTitle",
        "data-test-subj": "rollupJobCreateFlyoutTitle"
      }, /*#__PURE__*/_react.default.createElement("h2", null, buttonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
        placeholder: prompt,
        value: searchValue,
        onChange: this.onSearch,
        "aria-label": prompt,
        fullWidth: true
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
        items: searchedItems,
        columns: columns,
        rowProps: getRowProps,
        responsive: false,
        "data-test-subj": `${dataTestSubj}-table`
      })));
    };
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.onButtonClick,
      "data-test-subj": "rollupJobShowFieldChooserButton"
    }, buttonLabel), isOpen ? renderFlyout() : null);
  }
}
exports.FieldChooser = FieldChooser;
(0, _defineProperty2.default)(FieldChooser, "propTypes", {
  buttonLabel: _propTypes.default.node.isRequired,
  columns: _propTypes.default.array.isRequired,
  fields: _propTypes.default.array.isRequired,
  selectedFields: _propTypes.default.array.isRequired,
  onSelectField: _propTypes.default.func.isRequired,
  prompt: _propTypes.default.string,
  dataTestSubj: _propTypes.default.string
});
(0, _defineProperty2.default)(FieldChooser, "defaultProps", {
  prompt: 'Search',
  dataTestSubj: 'rollupJobFieldChooser'
});