"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportTypesRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ExportTypesRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "_map", new Map());
  }
  register(item) {
    if (!(0, _lodash.isString)(item.id)) {
      throw new Error(`'item' must have a String 'id' property `);
    }
    if (this._map.has(item.id)) {
      throw new Error(`'item' with id ${item.id} has already been registered`);
    }
    this._map.set(item.id, item);
  }
  getAll() {
    return Array.from(this._map.values());
  }
  getSize() {
    return this._map.size;
  }
  getById(id) {
    if (!this._map.has(id)) {
      throw new Error(`Unknown id ${id}`);
    }
    return this._map.get(id);
  }
  getByJobType(jobType) {
    let result;
    for (const value of this._map.values()) {
      if (value.jobType !== jobType) {
        continue;
      }
      const foundJobType = value;
      if (result) {
        throw new Error('Found multiple items matching predicate.');
      }
      result = foundJobType;
    }
    if (!result) {
      throw new Error('Found no items matching predicate');
    }
    return result;
  }
  get(findType) {
    let result;
    for (const value of this._map.values()) {
      if (!findType(value)) {
        continue; // try next value
      }

      const foundResult = value;
      if (result) {
        throw new Error('Found multiple items matching predicate.');
      }
      result = foundResult;
    }
    if (!result) {
      throw new Error('Found no items matching predicate');
    }
    return result;
  }
}
exports.ExportTypesRegistry = ExportTypesRegistry;