"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportingCsvPanelAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/discover-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _reportingExportTypesCsvCommon = require("@kbn/reporting-export-types-csv-common");
var _public3 = require("@kbn/ui-actions-plugin/public");
var _license_check = require("../lib/license_check");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isSavedSearchEmbeddable(embeddable) {
  return embeddable.type === _public.SEARCH_EMBEDDABLE_TYPE;
}
class ReportingCsvPanelAction {
  constructor({
    core,
    apiClient,
    startServices$,
    usesUiCapabilities
  }) {
    (0, _defineProperty2.default)(this, "isDownloading", void 0);
    (0, _defineProperty2.default)(this, "type", '');
    (0, _defineProperty2.default)(this, "id", _reportingExportTypesCsvCommon.CSV_REPORTING_ACTION);
    (0, _defineProperty2.default)(this, "notifications", void 0);
    (0, _defineProperty2.default)(this, "apiClient", void 0);
    (0, _defineProperty2.default)(this, "startServices$", void 0);
    (0, _defineProperty2.default)(this, "usesUiCapabilities", void 0);
    (0, _defineProperty2.default)(this, "isCompatible", async context => {
      var _application$capabili;
      const {
        embeddable
      } = context;
      if (embeddable.type !== 'search') {
        return false;
      }
      const [{
        application
      }, {
        licensing
      }] = await (0, _rxjs.firstValueFrom)(this.startServices$);
      const license = await (0, _rxjs.firstValueFrom)(licensing.license$);
      const licenseHasDownloadCsv = (0, _license_check.checkLicense)(license.check('reporting', 'basic')).showLinks;
      const capabilityHasDownloadCsv = this.usesUiCapabilities ? ((_application$capabili = application.capabilities.dashboard) === null || _application$capabili === void 0 ? void 0 : _application$capabili.downloadCsv) === true : true; // deprecated

      if (!licenseHasDownloadCsv || !capabilityHasDownloadCsv) {
        return false;
      }
      const savedSearch = embeddable.getSavedSearch();
      const query = savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.searchSource.getField('query');

      // using isOfAggregateQueryType(query) added increased the bundle size over the configured limit of 55.7KB
      if (query && Boolean(query && 'sql' in query)) {
        // hide exporting CSV for SQL
        return false;
      }
      return embeddable.getInput().viewMode !== _public2.ViewMode.EDIT;
    });
    (0, _defineProperty2.default)(this, "execute", async context => {
      const {
        embeddable
      } = context;
      if (!isSavedSearchEmbeddable(embeddable) || !(await this.isCompatible(context))) {
        throw new _public3.IncompatibleActionError();
      }
      const savedSearch = embeddable.getSavedSearch();
      if (!savedSearch || this.isDownloading) {
        return;
      }
      const {
        columns,
        getSearchSource
      } = await this.getSharingData(savedSearch);
      const immediateJobParams = this.apiClient.getDecoratedJobParams({
        searchSource: getSearchSource({
          addGlobalTimeFilter: !embeddable.hasTimeRange(),
          absoluteTime: true
        }),
        columns,
        title: savedSearch.title || '',
        objectType: 'downloadCsv' // FIXME: added for typescript, but immediate download job does not need objectType
      });

      this.isDownloading = true;
      this.notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.reporting.dashboard.csvDownloadStartedTitle', {
          defaultMessage: `CSV Download Started`
        }),
        text: _i18n.i18n.translate('xpack.reporting.dashboard.csvDownloadStartedMessage', {
          defaultMessage: `Your CSV will download momentarily.`
        }),
        'data-test-subj': 'csvDownloadStarted'
      });
      await this.apiClient.createImmediateReport(immediateJobParams).then(({
        body,
        response
      }) => {
        this.isDownloading = false;
        const download = `${savedSearch.title}.csv`;
        const blob = new Blob([body], {
          type: (response === null || response === void 0 ? void 0 : response.headers.get('content-type')) || undefined
        });

        // Hack for IE11 Support
        // @ts-expect-error
        if (window.navigator.msSaveOrOpenBlob) {
          // @ts-expect-error
          return window.navigator.msSaveOrOpenBlob(blob, download);
        }
        const a = window.document.createElement('a');
        const downloadObject = window.URL.createObjectURL(blob);
        a.href = downloadObject;
        a.download = download;
        document.body.appendChild(a);
        a.click();
        window.URL.revokeObjectURL(downloadObject);
        document.body.removeChild(a);
      }).catch(this.onGenerationFail.bind(this));
    });
    this.isDownloading = false;
    this.notifications = core.notifications;
    this.apiClient = apiClient;
    this.startServices$ = startServices$;
    this.usesUiCapabilities = usesUiCapabilities;
  }
  getIconType() {
    return 'document';
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.reporting.dashboard.downloadCsvPanelTitle', {
      defaultMessage: 'Download CSV'
    });
  }
  async getSharingData(savedSearch) {
    const [{
      uiSettings
    }, {
      data
    }] = await (0, _rxjs.firstValueFrom)(this.startServices$);
    const {
      getSharingData
    } = await (0, _public.loadSharingDataHelpers)();
    return await getSharingData(savedSearch.searchSource, savedSearch, {
      uiSettings,
      data
    });
  }
  onGenerationFail(_error) {
    this.isDownloading = false;
    this.notifications.toasts.addDanger({
      title: _i18n.i18n.translate('xpack.reporting.dashboard.failedCsvDownloadTitle', {
        defaultMessage: `CSV download failed`
      }),
      text: _i18n.i18n.translate('xpack.reporting.dashboard.failedCsvDownloadMessage', {
        defaultMessage: `We couldn't generate your CSV at this time.`
      }),
      'data-test-subj': 'downloadCsvFail'
    });
  }
}
exports.ReportingCsvPanelAction = ReportingCsvPanelAction;