"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportListingStateful = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _ilm_policy_status_context = require("../../lib/ilm_policy_status_context");
var _components = require("../components");
var _report_listing_table = require("../report_listing_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Used in Stateful deployments only
 * Renders controls for ILM and Screenshotting Diagnostics which are only applicable in Stateful
 */
const ReportListingStateful = props => {
  var _capabilities$managem, _capabilities$managem2;
  const {
    apiClient,
    capabilities,
    config,
    navigateToUrl,
    toasts,
    urlService,
    ...listingProps
  } = props;
  const ilmLocator = urlService.locators.get('ILM_LOCATOR_ID');
  const ilmPolicyContextValue = (0, _ilm_policy_status_context.useIlmPolicyStatus)();
  const hasIlmPolicy = (ilmPolicyContextValue === null || ilmPolicyContextValue === void 0 ? void 0 : ilmPolicyContextValue.status) !== 'policy-not-found';
  const showIlmPolicyLink = Boolean(ilmLocator && hasIlmPolicy);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "reportingPageHeader",
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.reports.titleStateful",
      defaultMessage: "Reports"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.reports.subtitleStateful",
      defaultMessage: "Get reports generated in Kibana applications."
    })
  }), /*#__PURE__*/_react.default.createElement(_components.MigrateIlmPolicyCallOut, {
    toasts: toasts
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'l'
  }), /*#__PURE__*/_react.default.createElement(_report_listing_table.ReportListingTable, (0, _extends2.default)({}, listingProps, {
    apiClient: apiClient,
    capabilities: capabilities,
    config: config,
    toasts: toasts,
    navigateToUrl: navigateToUrl,
    urlService: urlService
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, (capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$managem = capabilities.management) === null || _capabilities$managem === void 0 ? void 0 : (_capabilities$managem2 = _capabilities$managem.data) === null || _capabilities$managem2 === void 0 ? void 0 : _capabilities$managem2.index_lifecycle_management) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, ilmPolicyContextValue !== null && ilmPolicyContextValue !== void 0 && ilmPolicyContextValue.isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : showIlmPolicyLink && /*#__PURE__*/_react.default.createElement(_components.IlmPolicyLink, {
    navigateToUrl: navigateToUrl,
    locator: ilmLocator
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.ReportDiagnostic, {
    clientConfig: config,
    apiClient: apiClient
  }))));
};
exports.ReportListingStateful = ReportListingStateful;