"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PngExportType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _rxjs = require("rxjs");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingExportTypesPngCommon = require("@kbn/reporting-export-types-png-common");
var _reportingServer = require("@kbn/reporting-server");
var _generate_png = require("./generate_png");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class PngExportType extends _reportingServer.ExportType {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", _reportingExportTypesPngCommon.PNG_REPORT_TYPE_V2);
    (0, _defineProperty2.default)(this, "name", 'PNG');
    (0, _defineProperty2.default)(this, "jobType", _reportingExportTypesPngCommon.PNG_JOB_TYPE_V2);
    (0, _defineProperty2.default)(this, "jobContentEncoding", 'base64');
    (0, _defineProperty2.default)(this, "jobContentExtension", 'png');
    (0, _defineProperty2.default)(this, "validLicenses", [_reportingCommon.LICENSE_TYPE_TRIAL, _reportingCommon.LICENSE_TYPE_CLOUD_STANDARD, _reportingCommon.LICENSE_TYPE_GOLD, _reportingCommon.LICENSE_TYPE_PLATINUM, _reportingCommon.LICENSE_TYPE_ENTERPRISE]);
    /**
     * @params JobParamsPNGV2
     * @returns jobParams
     */
    (0, _defineProperty2.default)(this, "createJob", async ({
      locatorParams,
      ...jobParams
    }) => {
      return {
        ...jobParams,
        locatorParams: [locatorParams],
        isDeprecated: false,
        browserTimezone: jobParams.browserTimezone,
        forceNow: new Date().toISOString()
      };
    });
    /**
     *
     * @param jobId
     * @param payload
     * @param cancellationToken
     * @param stream
     */
    (0, _defineProperty2.default)(this, "runTask", (jobId, payload, cancellationToken, stream) => {
      const jobLogger = this.logger.get(`execute-job:${jobId}`);
      const apmTrans = _elasticApmNode.default.startTransaction('execute-job-pdf-v2', _reportingCommon.REPORTING_TRANSACTION_TYPE);
      const apmGetAssets = apmTrans.startSpan('get-assets', 'setup');
      let apmGeneratePng;
      const {
        encryptionKey
      } = this.config;
      const process$ = (0, _rxjs.of)(1).pipe((0, _rxjs.mergeMap)(() => (0, _reportingServer.decryptJobHeaders)(encryptionKey, payload.headers, jobLogger)), (0, _rxjs.mergeMap)(headers => {
        const url = (0, _reportingServer.getFullRedirectAppUrl)(this.config, this.getServerInfo(), payload.spaceId, payload.forceNow);
        const [locatorParams] = payload.locatorParams;
        apmGetAssets === null || apmGetAssets === void 0 ? void 0 : apmGetAssets.end();
        apmGeneratePng = apmTrans.startSpan('generate-png-pipeline', 'execute');
        return (0, _generate_png.generatePngObservable)(() => this.startDeps.screenshotting.getScreenshots({
          format: 'png',
          headers,
          layout: {
            ...payload.layout,
            id: 'preserve_layout'
          },
          urls: [[url, {
            [_reportingCommon.REPORTING_REDIRECT_LOCATOR_STORE_KEY]: locatorParams
          }]]
        }), jobLogger, {
          headers,
          browserTimezone: payload.browserTimezone,
          layout: {
            ...payload.layout,
            id: 'preserve_layout'
          }
        });
      }), (0, _rxjs.tap)(({
        buffer
      }) => stream.write(buffer)), (0, _rxjs.map)(({
        metrics,
        warnings
      }) => ({
        content_type: 'image/png',
        metrics: {
          png: metrics
        },
        warnings
      })), (0, _rxjs.tap)({
        error: error => jobLogger.error(error)
      }), (0, _rxjs.finalize)(() => {
        var _apmGeneratePng;
        return (_apmGeneratePng = apmGeneratePng) === null || _apmGeneratePng === void 0 ? void 0 : _apmGeneratePng.end();
      }));
      const stop$ = (0, _rxjs.fromEventPattern)(cancellationToken.on);
      return (0, _rxjs.lastValueFrom)(process$.pipe((0, _rxjs.takeUntil)(stop$)));
    });
    this.logger = this.logger.get('png-export-v2');
  }
}
exports.PngExportType = PngExportType;