"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterEdit = void 0;
var _reactRedux = require("react-redux");
var _remote_cluster_edit = require("./remote_cluster_edit");
var _selectors = require("../../store/selectors");
var _actions = require("../../store/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  return {
    isLoading: (0, _selectors.isLoading)(state),
    cluster: (0, _selectors.getEditedCluster)(state),
    isEditingCluster: (0, _selectors.isEditingCluster)(state),
    getEditClusterError: (0, _selectors.getEditClusterError)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    startEditingCluster: clusterName => {
      dispatch((0, _actions.startEditingCluster)({
        clusterName
      }));
    },
    stopEditingCluster: () => {
      dispatch((0, _actions.stopEditingCluster)());
    },
    editCluster: cluster => {
      dispatch((0, _actions.editCluster)(cluster));
    },
    clearEditClusterErrors: () => {
      dispatch((0, _actions.clearEditClusterErrors)());
    },
    openDetailPanel: clusterName => {
      dispatch((0, _actions.openDetailPanel)({
        name: clusterName
      }));
    }
  };
};
const RemoteClusterEdit = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_remote_cluster_edit.RemoteClusterEdit);
exports.RemoteClusterEdit = RemoteClusterEdit;