"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _feature = require("./feature");
var _routes = require("./routes");
var _create_profiling_es_client = require("./utils/create_profiling_es_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ProfilingPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.initializerContext = initializerContext;
    this.initializerContext = initializerContext;
    this.logger = initializerContext.logger.get();
  }
  setup(core, deps) {
    var _deps$usageCollection;
    const router = core.http.createRouter();
    deps.features.registerKibanaFeature(_feature.PROFILING_FEATURE);
    const config = this.initializerContext.config.get();
    const stackVersion = this.initializerContext.env.packageInfo.version;
    const telemetryUsageCounter = (_deps$usageCollection = deps.usageCollection) === null || _deps$usageCollection === void 0 ? void 0 : _deps$usageCollection.createUsageCounter(_feature.PROFILING_SERVER_FEATURE_ID);
    core.getStartServices().then(([coreStart, depsStart]) => {
      const profilingSpecificEsClient = config.elasticsearch ? coreStart.elasticsearch.createClient('profiling', {
        hosts: [config.elasticsearch.hosts],
        username: config.elasticsearch.username,
        password: config.elasticsearch.password
      }) : undefined;
      (0, _routes.registerRoutes)({
        router,
        logger: this.logger,
        dependencies: {
          start: depsStart,
          setup: deps,
          config,
          stackVersion,
          telemetryUsageCounter
        },
        services: {
          createProfilingEsClient: ({
            request,
            esClient: defaultEsClient,
            useDefaultAuth = false
          }) => {
            const esClient = profilingSpecificEsClient && !useDefaultAuth ? profilingSpecificEsClient.asScoped(request).asInternalUser : defaultEsClient;
            return (0, _create_profiling_es_client.createProfilingEsClient)({
              request,
              esClient
            });
          }
        }
      });
    });
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.ProfilingPlugin = ProfilingPlugin;