"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DifferentialFlameGraphsView = DifferentialFlameGraphsView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _flamegraph = require("../../../components/flamegraph");
var _normalization_menu = require("../../../components/normalization_menu");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_route_path = require("../../../hooks/use_profiling_route_path");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
var _differential_flame_graph_search_panel = require("./differential_flame_graph_search_panel");
var _frames_summary = require("../../../components/frames_summary");
var _use_async = require("../../../hooks/use_async");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DifferentialFlameGraphsView() {
  var _state$data, _state$data2;
  const {
    query,
    query: {
      rangeFrom,
      rangeTo,
      kuery,
      comparisonRangeFrom,
      comparisonRangeTo,
      comparisonKuery,
      comparisonMode,
      baseline = 1,
      comparison = 1,
      normalizationMode,
      searchText
    }
  } = (0, _use_profiling_params.useProfilingParams)('/flamegraphs/differential');
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const comparisonTimeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom: comparisonRangeFrom,
    rangeTo: comparisonRangeTo,
    optional: true
  });
  const {
    services: {
      fetchElasticFlamechart
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return Promise.all([fetchElasticFlamechart({
      http,
      timeFrom: new Date(timeRange.start).getTime(),
      timeTo: new Date(timeRange.end).getTime(),
      kuery
    }), comparisonTimeRange.start && comparisonTimeRange.end ? fetchElasticFlamechart({
      http,
      timeFrom: new Date(comparisonTimeRange.start).getTime(),
      timeTo: new Date(comparisonTimeRange.end).getTime(),
      kuery: comparisonKuery
    }) : Promise.resolve(undefined)]).then(([primaryFlamegraph, comparisonFlamegraph]) => {
      return {
        primaryFlamegraph,
        comparisonFlamegraph
      };
    });
  }, [fetchElasticFlamechart, timeRange.start, timeRange.end, kuery, comparisonTimeRange.start, comparisonTimeRange.end, comparisonKuery]);
  const totalSeconds = timeRange.inSeconds.end - timeRange.inSeconds.start;
  const totalComparisonSeconds = (new Date(comparisonTimeRange.end).getTime() - new Date(comparisonTimeRange.start).getTime()) / 1000;
  const baselineTime = 1;
  const comparisonTime = totalSeconds / totalComparisonSeconds;
  const normalizationOptions = {
    baselineScale: baseline,
    baselineTime,
    comparisonScale: comparison,
    comparisonTime
  };
  const {
    data
  } = state;
  const isNormalizedByTime = normalizationMode === _normalization_menu.NormalizationMode.Time;
  function handleSearchTextChange(newSearchText) {
    // @ts-expect-error Code gets too complicated to satisfy TS constraints
    profilingRouter.push(routePath, {
      query: {
        ...query,
        searchText: newSearchText
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_differential_flame_graph_search_panel.DifferentialFlameGraphSearchPanel, {
    comparisonMode: comparisonMode,
    normalizationMode: normalizationMode,
    normalizationOptions: normalizationOptions
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_frames_summary.FramesSummary, {
    isLoading: state.status === _use_async.AsyncStatus.Loading,
    baseValue: (_state$data = state.data) !== null && _state$data !== void 0 && _state$data.primaryFlamegraph ? {
      duration: totalSeconds,
      selfCPU: state.data.primaryFlamegraph.SelfCPU,
      totalCPU: state.data.primaryFlamegraph.TotalCPU,
      totalCount: state.data.primaryFlamegraph.TotalSamples,
      scaleFactor: isNormalizedByTime ? baselineTime : baseline,
      totalAnnualCO2Kgs: state.data.primaryFlamegraph.TotalAnnualCO2KgsItems[0],
      totalAnnualCostUSD: state.data.primaryFlamegraph.TotalAnnualCostsUSDItems[0]
    } : undefined,
    comparisonValue: (_state$data2 = state.data) !== null && _state$data2 !== void 0 && _state$data2.comparisonFlamegraph ? {
      duration: totalComparisonSeconds,
      selfCPU: state.data.comparisonFlamegraph.SelfCPU,
      totalCPU: state.data.comparisonFlamegraph.TotalCPU,
      totalCount: state.data.comparisonFlamegraph.TotalSamples,
      scaleFactor: isNormalizedByTime ? comparisonTime : comparison,
      totalAnnualCO2Kgs: state.data.comparisonFlamegraph.TotalAnnualCO2KgsItems[0],
      totalAnnualCostUSD: state.data.comparisonFlamegraph.TotalAnnualCostsUSDItems[0]
    } : undefined
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, state, {
    style: {
      height: '100%'
    },
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_flamegraph.FlameGraph, {
    id: "flamechart",
    primaryFlamegraph: data === null || data === void 0 ? void 0 : data.primaryFlamegraph,
    comparisonFlamegraph: data === null || data === void 0 ? void 0 : data.comparisonFlamegraph,
    comparisonMode: comparisonMode,
    baseline: isNormalizedByTime ? baselineTime : baseline,
    comparison: isNormalizedByTime ? comparisonTime : comparison,
    searchText: searchText,
    onChangeSearchText: handleSearchTextChange
  }))));
}