"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableSearchBar = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _react2 = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _profiling_search_bar = require("../../components/profiling_app_page_template/profiling_search_bar");
var _profiling_embeddable_provider = require("../profiling_embeddable_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EmbeddableSearchBar extends _public.Embeddable {
  constructor(deps, initialInput, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "type", _public2.EMBEDDABLE_PROFILING_SEARCH_BAR);
    (0, _defineProperty2.default)(this, "_domNode", void 0);
    this.deps = deps;
  }
  render(domNode) {
    this._domNode = domNode;
    const {
      showDatePicker,
      kuery,
      onQuerySubmit,
      onRefresh,
      rangeFrom,
      rangeTo
    } = this.input;
    (0, _reactDom.render)( /*#__PURE__*/_react2.default.createElement(_profiling_embeddable_provider.ProfilingEmbeddableProvider, {
      deps: this.deps
    }, /*#__PURE__*/_react2.default.createElement("div", {
      css: (0, _react.css)`
            width: 100%;
          `
    }, /*#__PURE__*/_react2.default.createElement(_profiling_search_bar.ProfilingSearchBar, {
      showDatePicker: showDatePicker || true,
      showSubmitButton: true,
      kuery: kuery,
      onQuerySubmit: ({
        dateRange,
        query
      }) => {
        onQuerySubmit({
          dateRange,
          query: typeof (query === null || query === void 0 ? void 0 : query.query) === 'string' ? query.query : ''
        });
      },
      onRefresh: onRefresh,
      onRefreshClick: onRefresh,
      showQueryMenu: false,
      rangeFrom: rangeFrom,
      rangeTo: rangeTo
    }))), domNode);
  }
  destroy() {
    if (this._domNode) {
      (0, _reactDom.unmountComponentAtNode)(this._domNode);
    }
  }
  reload() {
    if (this._domNode) {
      this.render(this._domNode);
    }
  }
}
exports.EmbeddableSearchBar = EmbeddableSearchBar;