"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PROFILING_FEEDBACK_LINK = void 0;
exports.ProfilingAppPageTemplate = ProfilingAppPageTemplate;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _primary_profiling_search_bar = require("./primary_profiling_search_bar");
var _use_local_storage = require("../../hooks/use_local_storage");
var _use_profiling_setup_status = require("../contexts/profiling_setup_status/use_profiling_setup_status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROFILING_FEEDBACK_LINK = 'https://ela.st/profiling-feedback';
exports.PROFILING_FEEDBACK_LINK = PROFILING_FEEDBACK_LINK;
function ProfilingAppPageTemplate({
  children,
  tabs = [],
  hideSearchBar = false,
  noDataConfig,
  restrictWidth = false,
  pageTitle = _i18n.i18n.translate('xpack.profiling.appPageTemplate.pageTitle', {
    defaultMessage: 'Universal Profiling'
  }),
  showBetaBadge = false
}) {
  const {
    start: {
      observabilityShared
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const [privilegesWarningDismissed, setPrivilegesWarningDismissed] = (0, _use_local_storage.useLocalStorage)('profiling.privilegesWarningDismissed', false);
  const {
    profilingSetupStatus
  } = (0, _use_profiling_setup_status.useProfilingSetupStatus)();
  const {
    PageTemplate: ObservabilityPageTemplate
  } = observabilityShared.navigation;
  const history = (0, _reactRouterDom.useHistory)();
  (0, _react.useEffect)(() => {
    window.scrollTo(0, 0);
  }, [history.location.pathname]);
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    noDataConfig: noDataConfig,
    pageHeader: {
      'data-test-subj': 'profilingPageTemplate',
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "profilingProfilingAppPageTemplateGiveFeedbackButton",
        href: PROFILING_FEEDBACK_LINK,
        target: "_blank",
        color: "warning",
        iconType: "editorComment"
      }, _i18n.i18n.translate('xpack.profiling.header.giveFeedbackLink', {
        defaultMessage: 'Give feedback'
      }))],
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "baseline"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("h1", null, pageTitle)), showBetaBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        label: "Beta",
        color: "hollow",
        tooltipContent: _i18n.i18n.translate('xpack.profiling.header.betaBadgeTooltip', {
          defaultMessage: 'This module is not GA. Please help us by reporting any bugs.'
        })
      }))),
      tabs
    },
    restrictWidth: restrictWidth,
    pageSectionProps: {
      contentProps: {
        style: {
          display: 'flex',
          flexGrow: 1
        }
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    style: {
      maxWidth: '100%'
    }
  }, !hideSearchBar && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_primary_profiling_search_bar.PrimaryProfilingSearchBar, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null))), (profilingSetupStatus === null || profilingSetupStatus === void 0 ? void 0 : profilingSetupStatus.unauthorized) === true && privilegesWarningDismissed !== true ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.profiling.privilegesWarningTitle', {
      defaultMessage: 'User privilege limitation'
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.profiling.privilegesWarningDescription', {
    defaultMessage: 'Due to privileges issues we could not check the Universal Profiling status. If you encounter any issues or if data fails to load, please contact your administrator for assistance.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "profilingProfilingAppPageTemplateDismissButton",
    onClick: () => {
      setPrivilegesWarningDismissed(true);
    }
  }, _i18n.i18n.translate('xpack.profiling.dismissPrivilegesCallout', {
    defaultMessage: 'Dismiss'
  })))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children)));
}