"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchStackTraces = searchStackTraces;
var _profilingUtils = require("@kbn/profiling-utils");
var _query = require("../../utils/query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function searchStackTraces({
  client,
  sampleSize,
  rangeFrom,
  rangeTo,
  kuery,
  durationSeconds,
  co2PerKWH,
  datacenterPUE,
  pervCPUWattX86,
  pervCPUWattArm64,
  awsCostDiscountRate,
  costPervCPUPerHour
}) {
  const response = await client.profilingStacktraces({
    query: {
      bool: {
        filter: [...(0, _query.kqlQuery)(kuery), {
          range: {
            ['@timestamp']: {
              gte: String(rangeFrom),
              lt: String(rangeTo),
              format: 'epoch_second',
              boost: 1.0
            }
          }
        }]
      }
    },
    sampleSize,
    durationSeconds,
    co2PerKWH,
    datacenterPUE,
    pervCPUWattX86,
    pervCPUWattArm64,
    awsCostDiscountRate,
    costPervCPUPerHour
  });
  return (0, _profilingUtils.decodeStackTraceResponse)(response);
}