"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.labsServiceFactory = void 0;
var _common = require("../../../common");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const labsServiceFactory = () => {
  let statuses = {};
  const getProject = id => {
    const project = _common.projects[id];
    const value = statuses[id];
    const status = {
      session: (0, _types.isEnabledByStorageValue)(project, 'session', value.session),
      browser: (0, _types.isEnabledByStorageValue)(project, 'browser', value.browser),
      kibana: (0, _types.isEnabledByStorageValue)(project, 'kibana', value.kibana)
    };
    return (0, _types.applyProjectStatus)(project, status);
  };
  const reset = () => _common.projectIDs.reduce((acc, id) => {
    const project = _common.projects[id];
    const defaultValue = project.isActive;
    acc[id] = {
      defaultValue,
      session: null,
      browser: null,
      kibana: defaultValue
    };
    return acc;
  }, {});
  statuses = reset();
  const getProjects = (solutions = []) => _common.projectIDs.reduce((acc, id) => {
    const project = getProject(id);
    if (solutions.length === 0 || solutions.some(solution => project.solutions.includes(solution))) {
      acc[id] = project;
    }
    return acc;
  }, {});
  const setProjectStatus = (id, env, value) => {
    statuses[id] = {
      ...statuses[id],
      [env]: value
    };
  };
  const isProjectEnabled = id => getProject(id).status.isEnabled;
  return {
    getProjectIDs: _common.getProjectIDs,
    getProject,
    getProjects,
    isProjectEnabled,
    setProjectStatus,
    reset: () => {
      statuses = reset();
    }
  };
};
exports.labsServiceFactory = labsServiceFactory;