"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginServiceProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A collection of `PluginServiceProvider` objects, keyed by the `Services` API generic.
 *
 * The `Services` generic determines the shape of all service APIs being produced.
 * The `StartParameters` generic determines what parameters are expected to
 * start the service.
 */

/**
 * An object which uses a given factory to start, stop or provide a service.
 *
 * The `Service` generic determines the shape of the API being produced.
 * The `StartParameters` generic determines what parameters are expected to
 * start the service.
 */
class PluginServiceProvider {
  constructor(factory, requiredServices) {
    (0, _defineProperty2.default)(this, "factory", void 0);
    (0, _defineProperty2.default)(this, "_requiredServices", void 0);
    (0, _defineProperty2.default)(this, "context", /*#__PURE__*/(0, _react.createContext)(null));
    (0, _defineProperty2.default)(this, "pluginService", null);
    (0, _defineProperty2.default)(this, "Provider", ({
      children
    }) => {
      return /*#__PURE__*/_react.default.createElement(this.context.Provider, {
        value: this.getService()
      }, children);
    });
    this.factory = factory;
    this._requiredServices = requiredServices;
    this.context.displayName = 'PluginServiceContext';
  }

  /**
   * Getter that will enforce proper setup throughout the class.
   */
  getService() {
    if (!this.pluginService) {
      throw new Error('Service not started');
    }
    return this.pluginService;
  }

  /**
   * Start the service.
   *
   * @param params Parameters used to start the service.
   */
  start(params, requiredServices) {
    this.pluginService = this.factory(params, requiredServices);
  }

  /**
   * Returns a function for providing a Context hook for the service.
   */
  getServiceReactHook() {
    return () => {
      const service = (0, _react.useContext)(this.context);
      if (!service) {
        throw new Error('Provider is not set up correctly');
      }
      return service;
    };
  }

  /**
   * Stop the service.
   */
  stop() {
    this.pluginService = null;
  }
  get requiredServices() {
    var _this$_requiredServic;
    return (_this$_requiredServic = this._requiredServices) !== null && _this$_requiredServic !== void 0 ? _this$_requiredServic : [];
  }
}
exports.PluginServiceProvider = PluginServiceProvider;