"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewPicker = DataViewPicker;
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DataViewPicker({
  dataViews,
  selectedDataViewId,
  onChangeDataViewId,
  trigger,
  selectableProps,
  ...other
}) {
  const [isPopoverOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  const isMissingCurrent = !dataViews.some(({
    id
  }) => id === selectedDataViewId);

  // be careful to only add color with a value, otherwise it will fallbacks to "primary"
  const colorProp = isMissingCurrent ? {
    color: 'danger'
  } : {};
  const createTrigger = function () {
    const {
      label,
      title,
      ...rest
    } = trigger;
    return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarButton, (0, _extends2.default)({
      "aria-label": title,
      "data-test-subj": "open-data-view-picker",
      onClick: () => setPopoverIsOpen(!isPopoverOpen),
      label: label,
      fullWidth: true
    }, colorProp, rest));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, (0, _extends2.default)({}, other, {
    ownFocus: true,
    fullWidth: true,
    display: "block",
    panelPaddingSize: "s",
    isOpen: isPopoverOpen,
    input: createTrigger(),
    closePopover: () => setPopoverIsOpen(false),
    panelMinWidth: (0, _calculateWidthFromCharCount.calculateWidthFromEntries)(dataViews, ['name', 'id']),
    panelProps: {
      'data-test-subj': 'data-view-picker-popover'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, (0, _extends2.default)({}, selectableProps, {
    searchable: true,
    singleSelection: "always",
    options: dataViews.map(({
      name,
      id,
      title
    }) => ({
      key: id,
      label: name !== null && name !== void 0 ? name : title,
      value: id,
      'data-test-subj': `data-view-picker-${name !== null && name !== void 0 ? name : title}`,
      checked: id === selectedDataViewId ? 'on' : undefined
    })),
    onChange: choices => {
      const choice = choices.find(({
        checked
      }) => checked);
      onChangeDataViewId(choice.value);
      setPopoverIsOpen(false);
    },
    searchProps: {
      compressed: true,
      ...(selectableProps ? selectableProps.searchProps : undefined)
    },
    listProps: {
      truncationProps: {
        truncation: 'middle'
      }
    }
  }), (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list)));
}

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
var _default = DataViewPicker;
exports.default = _default;