"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardPicker = DashboardPicker;
exports.default = void 0;
var _lodash = require("lodash");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _services = require("../../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DashboardPicker({
  isDisabled,
  onChange,
  idsToOmit
}) {
  var _selectedDashboard$la;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isLoading, setIsLoading] = (0, _react2.useState)(true);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const [dashboardHits, setDashboardHits] = (0, _react2.useState)([]);
  const [dashboardOptions, setDashboardOptions] = (0, _react2.useState)([]);
  const [query, setQuery] = (0, _react2.useState)('');
  const [debouncedQuery, setDebouncedQuery] = (0, _react2.useState)('');
  const [selectedDashboard, setSelectedDashboard] = (0, _react2.useState)(null);
  const {
    contentManagement: {
      client: cmClient
    }
  } = _services.pluginServices.getServices();

  /**
   * Debounce the query to avoid many calls to content management.
   */
  const debouncedSetQuery = (0, _react2.useMemo)(() => (0, _lodash.debounce)(latestQuery => setDebouncedQuery(latestQuery), 150), []);
  (0, _react2.useEffect)(() => {
    debouncedSetQuery(query);
  }, [debouncedSetQuery, query]);

  /**
   * Run query to search for Dashboards when debounced query changes.
   */
  (0, _react2.useEffect)(() => {
    let canceled = false;
    (async () => {
      setIsLoading(true);
      const response = await cmClient.mSearch({
        contentTypes: [{
          contentTypeId: 'dashboard'
        }],
        query: {
          text: debouncedQuery ? `${debouncedQuery}*` : undefined,
          limit: 30
        }
      });
      if (canceled) return;
      if (response && response.hits) {
        setDashboardHits(response.hits);
      }
      setIsLoading(false);
    })();
    return () => {
      canceled = true;
    };
  }, [debouncedQuery, cmClient]);

  /**
   * Format items with dashboard hits and selected option
   */
  (0, _react2.useEffect)(() => {
    setDashboardOptions(dashboardHits.filter(d => !d.managed && !(idsToOmit !== null && idsToOmit !== void 0 ? idsToOmit : []).includes(d.id)).map(d => ({
      value: d.id,
      label: d.attributes.title,
      checked: d.id === (selectedDashboard === null || selectedDashboard === void 0 ? void 0 : selectedDashboard.value) ? 'on' : undefined,
      'data-test-subj': `dashboard-picker-option-${d.attributes.title.replaceAll(' ', '-')}`
    })));
  }, [dashboardHits, idsToOmit, selectedDashboard]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiInputPopover, {
    panelPaddingSize: "none",
    input: /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      isDisabled: isDisabled,
      fullWidth: true,
      isLoading: isLoading,
      "data-test-subj": "open-dashboard-picker",
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      label: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s",
        css: (0, _react.css)`
                color: ${selectedDashboard ? euiTheme.colors.text : euiTheme.colors.disabledText};
              `
      }, (_selectedDashboard$la = selectedDashboard === null || selectedDashboard === void 0 ? void 0 : selectedDashboard.label) !== null && _selectedDashboard$la !== void 0 ? _selectedDashboard$la : _i18n.i18n.translate('presentationUtil.dashboardPicker.noDashboardOptionLabel', {
        defaultMessage: 'Select dashboard'
      }))
    }),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false)
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldSearch, {
    compressed: true,
    fullWidth: true,
    onChange: event => setQuery(event.target.value),
    value: query,
    "data-test-subj": "dashboard-picker-search",
    placeholder: _i18n.i18n.translate('presentationUtil.dashboardPicker.searchDashboardPlaceholder', {
      defaultMessage: 'Search dashboards...'
    })
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    singleSelection: true,
    options: dashboardOptions,
    onChange: (newOptions, event, selected) => {
      setIsPopoverOpen(false);
      if (!selected || selected.value === (selectedDashboard === null || selectedDashboard === void 0 ? void 0 : selectedDashboard.value)) return;
      setSelectedDashboard(selected);
      onChange({
        name: selected.label,
        id: selected.value
      });
    },
    renderOption: option => /*#__PURE__*/_react2.default.createElement(_eui.EuiHighlight, {
      search: query
    }, option.label)
  }, list => /*#__PURE__*/_react2.default.createElement("div", null, list)));
}

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
var _default = DashboardPicker;
exports.default = _default;