"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAppContext = exports.AppContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _initial_payload = require("./initial_payload");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const validatePayload = payload => {
  const {
    index
  } = payload;

  // For now just validate that the user has entered an index.
  const indexExists = Boolean(index || index.trim());
  return {
    isValid: indexExists,
    fields: {
      index: indexExists
    }
  };
};
const AppContextProvider = ({
  children,
  value: {
    http,
    links,
    chrome
  }
}) => {
  const PAINLESS_LAB_KEY = 'painlessLabState';
  const [store, setStore] = (0, _react.useState)(() => {
    // Using a callback here ensures these values are only calculated on the first render.
    const defaultPayload = {
      ..._initial_payload.initialPayload,
      ...JSON.parse(localStorage.getItem(PAINLESS_LAB_KEY) || '{}')
    };
    return {
      payload: defaultPayload,
      validation: validatePayload(defaultPayload)
    };
  });
  const updatePayload = changes => {
    const nextPayload = {
      ...store.payload,
      ...changes
    };
    // Persist state locally so we can load it up when the user reopens the app.
    localStorage.setItem(PAINLESS_LAB_KEY, JSON.stringify(nextPayload));
    setStore({
      payload: nextPayload,
      validation: validatePayload(nextPayload)
    });
  };
  return /*#__PURE__*/_react.default.createElement(AppContext.Provider, {
    value: {
      updatePayload,
      store,
      services: {
        http,
        chrome
      },
      links
    }
  }, children);
};
exports.AppContextProvider = AppContextProvider;
const useAppContext = () => {
  const ctx = (0, _react.useContext)(AppContext);
  if (!ctx) {
    throw new Error('AppContext can only be used inside of AppContextProvider!');
  }
  return ctx;
};
exports.useAppContext = useAppContext;