"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentPolicyRoute = void 0;
var _route_validation = require("../../utils/build_validation/route_validation");
var _constants = require("../../../common/constants");
var _common = require("../../../common");
var _utils = require("../utils");
var _api = require("../../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAgentPolicyRoute = (router, osqueryContext) => {
  router.versioned.get({
    access: 'internal',
    path: '/internal/osquery/fleet_wrapper/agent_policies/{id}',
    options: {
      tags: [`access:${_common.PLUGIN_ID}-read`]
    }
  }).addVersion({
    version: _constants.API_VERSIONS.internal.v1,
    validate: {
      request: {
        params: (0, _route_validation.buildRouteValidation)(_api.getAgentPolicyRequestParamsSchema)
      }
    }
  }, async (context, request, response) => {
    var _osqueryContext$servi;
    const internalSavedObjectsClient = await (0, _utils.getInternalSavedObjectsClient)(osqueryContext.getStartServices);
    const packageInfo = await ((_osqueryContext$servi = osqueryContext.service.getAgentPolicyService()) === null || _osqueryContext$servi === void 0 ? void 0 : _osqueryContext$servi.get(internalSavedObjectsClient, request.params.id));
    return response.ok({
      body: {
        item: packageInfo
      }
    });
  });
};
exports.getAgentPolicyRoute = getAgentPolicyRoute;