"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryAppRoutes = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _use_breadcrumbs = require("../common/hooks/use_breadcrumbs");
var _live_queries = require("./live_queries");
var _saved_queries = require("./saved_queries");
var _packs = require("./packs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OsqueryAppRoutesComponent = () => {
  (0, _use_breadcrumbs.useBreadcrumbs)('base');
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/packs`
  }, /*#__PURE__*/_react.default.createElement(_packs.Packs, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/saved_queries`
  }, /*#__PURE__*/_react.default.createElement(_saved_queries.SavedQueries, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/live_queries"
  }, /*#__PURE__*/_react.default.createElement(_live_queries.LiveQueries, null)), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: "/live_queries"
  }));
};
const OsqueryAppRoutes = /*#__PURE__*/_react.default.memo(OsqueryAppRoutesComponent);
exports.OsqueryAppRoutes = OsqueryAppRoutes;