"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackResultsHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _add_to_timeline_button = require("../../timelines/add_to_timeline_button");
var _add_to_cases = require("../../cases/add_to_cases");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resultsHeadingCss = ({
  euiTheme
}) => ({
  paddingRight: '20px',
  borderRight: euiTheme.border.thick
});
const iconsListCss = {
  alignContent: 'center',
  justifyContent: 'center',
  paddingLeft: '10px'
};
const PackResultsHeader = /*#__PURE__*/_react.default.memo(({
  actionId,
  agentIds,
  queryIds
}) => {
  const iconProps = (0, _react.useMemo)(() => ({
    color: 'text',
    size: 'xs',
    iconSize: 'l'
  }), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'l'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: resultsHeadingCss,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.liveQueryActionResults.results",
    defaultMessage: "Results"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: iconsListCss,
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, actionId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_add_to_cases.AddToCaseWrapper, {
    actionId: actionId,
    agentIds: agentIds,
    isIcon: true,
    iconProps: iconProps
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_add_to_timeline_button.AddToTimelineButton, {
    field: "action_id",
    value: queryIds,
    isIcon: true,
    iconProps: iconProps
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'l'
  }));
});
exports.PackResultsHeader = PackResultsHeader;
PackResultsHeader.displayName = 'PackResultsHeader';