"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewResultsActionButtonType = exports.PackQueriesStatusTable = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _query_details_flyout = require("./query_details_flyout");
var _pack_results_header = require("./pack_results_header");
var _search_strategy = require("../../../common/search_strategy");
var _remove_multilines = require("../../../common/utils/build_query/remove_multilines");
var _tabs = require("../../routes/saved_queries/edit/tabs");
var _pack_view_in_lens = require("../../lens/pack_view_in_lens");
var _pack_view_in_discover = require("../../discover/pack_view_in_discover");
var _add_to_cases = require("../../cases/add_to_cases");
var _add_to_timeline_button = require("../../timelines/add_to_timeline_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const truncateTooltipTextCss = {
  width: '100%',
  '> span': {
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap'
  }
};
const euiFlexItemCss = {
  cursor: 'pointer'
};

// TODO fix types
const euiBasicTableCss = {
  '.euiTableRow.euiTableRow-isExpandedRow > td > div': {
    padding: '0',
    border: '1px solid #d3dae6'
  },
  'div.euiDataGrid__virtualized::-webkit-scrollbar': {
    display: 'none'
  },
  '.euiDataGrid > div': {
    '.euiDataGrid__scrollOverlay': {
      boxShadow: 'none'
    },
    borderLeft: '0px',
    borderRight: '0px'
  }
};
const EMPTY_ARRAY = [];
let ViewResultsActionButtonType;
exports.ViewResultsActionButtonType = ViewResultsActionButtonType;
(function (ViewResultsActionButtonType) {
  ViewResultsActionButtonType["icon"] = "icon";
  ViewResultsActionButtonType["button"] = "button";
})(ViewResultsActionButtonType || (exports.ViewResultsActionButtonType = ViewResultsActionButtonType = {}));
const DocsColumnResults = ({
  count,
  isLive
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, count ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  color: "subdued"
}, count) : '-'), !isLive ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  "data-test-subj": 'live-query-loading'
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)) : null);
const AgentsColumnResults = ({
  successful,
  pending,
  failed
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: "success"
}, successful), ' / ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: "default"
}, pending), ' / ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: failed ? 'danger' : 'default'
}, failed))));
const PackQueriesStatusTableComponent = ({
  actionId,
  queryId,
  agentIds,
  data,
  startDate,
  expirationDate,
  showResultsHeader
}) => {
  const [queryDetailsFlyoutOpen, setQueryDetailsFlyoutOpen] = (0, _react.useState)(null);
  const handleQueryFlyoutOpen = (0, _react.useCallback)(item => () => {
    setQueryDetailsFlyoutOpen(item);
  }, []);
  const handleQueryFlyoutClose = (0, _react.useCallback)(() => setQueryDetailsFlyoutOpen(null), []);
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const renderIDColumn = (0, _react.useCallback)(id => /*#__PURE__*/_react.default.createElement("div", {
    css: truncateTooltipTextCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: id,
    display: "block"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, id))), []);
  const renderQueryColumn = (0, _react.useCallback)((query, item) => {
    const singleLine = (0, _remove_multilines.removeMultilines)(query);
    const content = singleLine.length > 55 ? `${singleLine.substring(0, 55)}...` : singleLine;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: euiFlexItemCss,
      onClick: handleQueryFlyoutOpen(item)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "sql",
      fontSize: "s",
      paddingSize: "none",
      transparentBackground: true
    }, content));
  }, [handleQueryFlyoutOpen]);
  const renderDocsColumn = (0, _react.useCallback)(item => {
    var _item$docs;
    const isLive = !(item !== null && item !== void 0 && item.status) || !!item.error || (item === null || item === void 0 ? void 0 : item.status) !== 'running' && (item === null || item === void 0 ? void 0 : item.pending) === 0;
    return /*#__PURE__*/_react.default.createElement(DocsColumnResults, {
      count: (_item$docs = item === null || item === void 0 ? void 0 : item.docs) !== null && _item$docs !== void 0 ? _item$docs : 0,
      isLive: isLive
    });
  }, []);
  const renderAgentsColumn = (0, _react.useCallback)(item => {
    var _item$successful, _item$pending, _item$failed;
    if (!item.action_id) return;
    return /*#__PURE__*/_react.default.createElement(AgentsColumnResults, {
      successful: (_item$successful = item === null || item === void 0 ? void 0 : item.successful) !== null && _item$successful !== void 0 ? _item$successful : 0,
      pending: (_item$pending = item === null || item === void 0 ? void 0 : item.pending) !== null && _item$pending !== void 0 ? _item$pending : 0,
      failed: (_item$failed = item === null || item === void 0 ? void 0 : item.failed) !== null && _item$failed !== void 0 ? _item$failed : 0
    });
  }, []);
  const renderDiscoverResultsAction = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(_pack_view_in_discover.PackViewInDiscoverAction, {
    item: item
  }), []);
  const renderLensResultsAction = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(_pack_view_in_lens.PackViewInLensAction, {
    item: item
  }), []);
  const getHandleErrorsToggle = (0, _react.useCallback)(item => () => {
    setItemIdToExpandedRowMap(prevValue => {
      const itemIdToExpandedRowMapValues = {
        ...prevValue
      };
      if (itemIdToExpandedRowMapValues[item.id]) {
        delete itemIdToExpandedRowMapValues[item.id];
      } else {
        var _item$failed2;
        itemIdToExpandedRowMapValues[item.id] = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "xl"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_tabs.ResultTabs, {
          liveQueryActionId: actionId,
          actionId: item.action_id,
          startDate: startDate,
          ecsMapping: item.ecs_mapping,
          endDate: expirationDate,
          agentIds: agentIds,
          failedAgentsCount: (_item$failed2 = item === null || item === void 0 ? void 0 : item.failed) !== null && _item$failed2 !== void 0 ? _item$failed2 : 0,
          error: item.error
        })));
      }
      return itemIdToExpandedRowMapValues;
    });
  }, [actionId, startDate, expirationDate, agentIds]);
  const renderToggleResultsAction = (0, _react.useCallback)(item => item !== null && item !== void 0 && item.action_id && data !== null && data !== void 0 && data.length && data.length > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `toggleIcon-${item.id}`,
    onClick: getHandleErrorsToggle(item),
    iconType: itemIdToExpandedRowMap[item.id] ? 'arrowUp' : 'arrowDown'
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), [data, getHandleErrorsToggle, itemIdToExpandedRowMap]);
  const getItemId = (0, _react.useCallback)(item => (0, _lodash.get)(item, 'id'), []);
  const renderResultActions = (0, _react.useCallback)(row => {
    const resultActions = [{
      render: renderDiscoverResultsAction
    }, {
      render: renderLensResultsAction
    }, {
      render: item => item.action_id && /*#__PURE__*/_react.default.createElement(_add_to_timeline_button.AddToTimelineButton, {
        field: "action_id",
        value: item.action_id,
        isIcon: true
      })
    }, {
      render: item => actionId && /*#__PURE__*/_react.default.createElement(_add_to_cases.AddToCaseWrapper, {
        actionId: actionId,
        agentIds: agentIds,
        queryId: item.action_id,
        isIcon: true,
        isDisabled: !item.action_id
      })
    }, {
      render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: 'expand',
        onClick: handleQueryFlyoutOpen(item)
      })
    }];
    return resultActions.map(action => action.render(row));
  }, [actionId, agentIds, handleQueryFlyoutOpen, renderDiscoverResultsAction, renderLensResultsAction]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'id',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.idColumnTitle', {
      defaultMessage: 'ID'
    }),
    width: '15%',
    render: renderIDColumn
  }, {
    field: 'query',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.queryColumnTitle', {
      defaultMessage: 'Query'
    }),
    render: renderQueryColumn,
    width: '40%'
  }, {
    field: '',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.docsResultsColumnTitle', {
      defaultMessage: 'Docs'
    }),
    width: '80px',
    render: renderDocsColumn
  }, {
    field: '',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.agentsResultsColumnTitle', {
      defaultMessage: 'Agents'
    }),
    width: '160px',
    render: renderAgentsColumn
  }, {
    field: '',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.viewResultsColumnTitle', {
      defaultMessage: 'View results'
    }),
    width: '120px',
    render: renderResultActions
  }, {
    field: '',
    id: 'actions',
    width: '45px',
    isVisuallyHiddenLabel: true,
    alignment: _eui.RIGHT_ALIGNMENT,
    actions: [{
      render: renderToggleResultsAction
    }]
  }], [renderIDColumn, renderQueryColumn, renderDocsColumn, renderAgentsColumn, renderResultActions, renderToggleResultsAction]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: 'id',
      direction: _search_strategy.Direction.asc
    }
  }), []);
  (0, _react.useEffect)(() => {
    // reset the expanded row map when the data changes
    setItemIdToExpandedRowMap({});
  }, [queryId, actionId]);
  (0, _react.useEffect)(() => {
    if ((data === null || data === void 0 ? void 0 : data.length) === 1 && agentIds !== null && agentIds !== void 0 && agentIds.length && data !== null && data !== void 0 && data[0].id && !itemIdToExpandedRowMap[data === null || data === void 0 ? void 0 : data[0].id]) {
      getHandleErrorsToggle(data === null || data === void 0 ? void 0 : data[0])();
    }
  }, [agentIds === null || agentIds === void 0 ? void 0 : agentIds.length, data, getHandleErrorsToggle, itemIdToExpandedRowMap]);
  const queryIds = (0, _react.useMemo)(() => (0, _lodash.map)(data, query => query.action_id), [data]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showResultsHeader && /*#__PURE__*/_react.default.createElement(_pack_results_header.PackResultsHeader, {
    queryIds: queryIds,
    actionId: actionId,
    agentIds: agentIds
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    css: euiBasicTableCss,
    items: data !== null && data !== void 0 ? data : EMPTY_ARRAY,
    itemId: getItemId,
    columns: columns,
    sorting: sorting,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    isExpandable: true
  }), queryDetailsFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_query_details_flyout.QueryDetailsFlyout, {
    onClose: handleQueryFlyoutClose,
    action: queryDetailsFlyoutOpen
  }) : null);
};
const PackQueriesStatusTable = /*#__PURE__*/_react.default.memo(PackQueriesStatusTableComponent);
exports.PackQueriesStatusTable = PackQueriesStatusTable;