"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeoutField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeoutFieldComponent = ({
  euiFieldProps
}) => {
  const {
    field: {
      onChange,
      value
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    name: 'timeout',
    defaultValue: _constants.QUERY_TIMEOUT.DEFAULT,
    rules: {
      validate: currentValue => {
        if (currentValue < _constants.QUERY_TIMEOUT.DEFAULT || isNaN(currentValue)) {
          return _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.timeoutFieldMinNumberError', {
            defaultMessage: 'The timeout value must be {timeoutInSeconds} seconds or higher.',
            values: {
              timeoutInSeconds: _constants.QUERY_TIMEOUT.DEFAULT
            }
          });
        }
        if (currentValue > _constants.QUERY_TIMEOUT.MAX) {
          return _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.timeoutFieldMaxNumberError', {
            defaultMessage: 'The timeout value must be {timeoutInSeconds} seconds or or lower. ',
            values: {
              timeoutInSeconds: _constants.QUERY_TIMEOUT.MAX
            }
          });
        }
      }
    }
  });
  const handleChange = (0, _react.useCallback)(e => {
    const numberValue = parseInt(e.target.value, 10);
    onChange(numberValue);
  }, [onChange]);
  const hasError = (0, _react.useMemo)(() => !!(error !== null && error !== void 0 && error.message), [error === null || error === void 0 ? void 0 : error.message]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.liveQuery.timeout",
      defaultMessage: "Timeout"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.osquery.liveQuery.timeoutHint', {
        defaultMessage: 'The default and minimum timeout period is 60 seconds. Increase this value if your query needs more time to run.'
      })
    }))),
    fullWidth: true,
    error: error === null || error === void 0 ? void 0 : error.message,
    isInvalid: hasError
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({
    isInvalid: hasError,
    value: value,
    onChange: handleChange,
    fullWidth: true,
    type: "number",
    "data-test-subj": "timeout-input",
    name: "timeout",
    min: _constants.QUERY_TIMEOUT.DEFAULT,
    max: _constants.QUERY_TIMEOUT.MAX,
    defaultValue: _constants.QUERY_TIMEOUT.DEFAULT,
    step: 1,
    append: "seconds"
  }, euiFieldProps)));
};
const TimeoutField = /*#__PURE__*/_react.default.memo(TimeoutFieldComponent, _fastDeepEqual.default);
exports.TimeoutField = TimeoutField;