"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateGroupOption = exports.generateAgentOption = exports.AgentGrouper = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _helpers = require("./helpers");
var _translations = require("./translations");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getColor = (0, _helpers.generateColorPicker)();
const generateGroup = (label, groupType) => ({
  label,
  groupType,
  color: getColor(groupType),
  size: 0,
  data: []
});
const generateAgentOption = (label, groupType, data) => ({
  label,
  options: data.map(agent => {
    var _agent$policy_id, _agent$status;
    return {
      disabled: agent.status !== 'online',
      label: `${agent.local_metadata.host.hostname} (${agent.local_metadata.elastic.agent.id})`,
      key: agent.local_metadata.elastic.agent.id,
      color: agent.status !== 'online' ? 'danger' : getColor(groupType),
      value: {
        groupType,
        groups: {
          policy: (_agent$policy_id = agent.policy_id) !== null && _agent$policy_id !== void 0 ? _agent$policy_id : '',
          platform: agent.local_metadata.os.platform
        },
        id: agent.local_metadata.elastic.agent.id,
        status: (_agent$status = agent.status) !== null && _agent$status !== void 0 ? _agent$status : 'unknown'
      }
    };
  })
});
exports.generateAgentOption = generateAgentOption;
const generateGroupOption = (label, groupType, data) => ({
  label,
  options: data.map(({
    name,
    id,
    size
  }) => ({
    label: name !== id ? `${name} (${id})` : name,
    key: id,
    color: getColor(groupType),
    value: {
      groupType,
      id,
      size
    }
  }))
});
exports.generateGroupOption = generateGroupOption;
class AgentGrouper {
  constructor() {
    (0, _defineProperty2.default)(this, "groupOrder", [_types.AGENT_GROUP_KEY.All, _types.AGENT_GROUP_KEY.Platform, _types.AGENT_GROUP_KEY.Policy, _types.AGENT_GROUP_KEY.Agent]);
    (0, _defineProperty2.default)(this, "groups", {
      [_types.AGENT_GROUP_KEY.All]: generateGroup(_translations.ALL_AGENTS_LABEL, _types.AGENT_GROUP_KEY.All),
      [_types.AGENT_GROUP_KEY.Platform]: generateGroup(_translations.AGENT_PLATFORMS_LABEL, _types.AGENT_GROUP_KEY.Platform),
      [_types.AGENT_GROUP_KEY.Policy]: generateGroup(_translations.AGENT_POLICY_LABEL, _types.AGENT_GROUP_KEY.Policy),
      [_types.AGENT_GROUP_KEY.Agent]: generateGroup(_translations.AGENT_SELECTION_LABEL, _types.AGENT_GROUP_KEY.Agent)
    });
  }
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  updateGroup(key, data, append = false) {
    if (!(data !== null && data !== void 0 && data.length) || key === _types.AGENT_GROUP_KEY.All) {
      return;
    }
    const group = this.groups[key];
    if (append) {
      group.data.push(...data);
    } else {
      group.data = data;
    }
    group.size = data.length;
  }
  setTotalAgents(total) {
    if (total < 0) {
      return;
    }
    this.groups[_types.AGENT_GROUP_KEY.All].size = total;
  }
  generateOptions() {
    const opts = [];
    for (const key of this.groupOrder) {
      const {
        label,
        size,
        groupType,
        data,
        color
      } = this.groups[key];
      if (size === 0) {
        continue;
      }
      switch (key) {
        case _types.AGENT_GROUP_KEY.All:
          opts.push({
            label,
            options: [{
              label,
              value: {
                groupType,
                size
              },
              color
            }]
          });
          break;
        case _types.AGENT_GROUP_KEY.Platform:
        case _types.AGENT_GROUP_KEY.Policy:
          opts.push(generateGroupOption(label, key, data));
          break;
        case _types.AGENT_GROUP_KEY.Agent:
          opts.push(generateAgentOption(label, key, data));
          break;
      }
    }
    return opts;
  }
}
exports.AgentGrouper = AgentGrouper;