"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEsParams = createEsParams;
exports.useEsSearch = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _get_inspect_response = require("../../common/utils/get_inspect_response");
var _use_inspector_context = require("../contexts/inspector/use_inspector_context");
var _use_fetcher = require("./use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEsSearch = (params, fnDeps, options) => {
  const {
    services: {
      data
    }
  } = (0, _public.useKibana)();
  const {
    name
  } = options !== null && options !== void 0 ? options : {};
  const {
    addInspectorRequest
  } = (0, _use_inspector_context.useInspectorContext)();
  const {
    data: response = {},
    loading
  } = (0, _use_fetcher.useFetcher)(() => {
    if (params.index) {
      const startTime = Date.now();
      return new Promise(resolve => {
        const search$ = data.search.search({
          params
        }, {
          legacyHitsTotal: false
        }).subscribe({
          next: result => {
            if (!(0, _common.isRunningResponse)(result)) {
              if (addInspectorRequest) {
                addInspectorRequest({
                  data: {
                    _inspect: [(0, _get_inspect_response.getInspectResponse)({
                      startTime,
                      esRequestParams: params,
                      esResponse: result.rawResponse,
                      esError: null,
                      esRequestStatus: 1,
                      operationName: name,
                      kibanaRequest: {
                        route: {
                          path: '/internal/bsearch',
                          method: 'POST'
                        }
                      }
                    })]
                  },
                  status: _use_fetcher.FETCH_STATUS.SUCCESS
                });
              }
              // Final result
              resolve(result);
              search$.unsubscribe();
            }
          },
          error: err => {
            // eslint-disable-next-line no-console
            console.error(err);
            if (addInspectorRequest) {
              addInspectorRequest({
                data: {
                  _inspect: [(0, _get_inspect_response.getInspectResponse)({
                    startTime,
                    esRequestParams: params,
                    esResponse: null,
                    esError: {
                      originalError: err,
                      name: err.name,
                      message: err.message
                    },
                    esRequestStatus: 2,
                    operationName: name,
                    kibanaRequest: {
                      route: {
                        path: '/internal/bsearch',
                        method: 'POST'
                      }
                    }
                  })]
                },
                status: _use_fetcher.FETCH_STATUS.SUCCESS
              });
            }
          }
        });
      });
    }
  }, [...fnDeps]);
  const {
    rawResponse
  } = response;
  return {
    data: rawResponse,
    loading: Boolean(loading)
  };
};
exports.useEsSearch = useEsSearch;
function createEsParams(params) {
  return params;
}