"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetCustomMetricIndicatorAggregation = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _transform_generators = require("../transform_generators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GetCustomMetricIndicatorAggregation {
  constructor(indicator) {
    this.indicator = indicator;
  }
  buildMetricAggregations(type, metricDef) {
    return metricDef.metrics.reduce((acc, metric) => {
      const filter = metric.filter ? (0, _transform_generators.getElastichsearchQueryOrThrow)(metric.filter) : {
        match_all: {}
      };
      if (_sloSchema.metricCustomDocCountMetric.is(metric)) {
        return {
          ...acc,
          [`_${type}_${metric.name}`]: {
            filter
          }
        };
      }
      return {
        ...acc,
        [`_${type}_${metric.name}`]: {
          filter,
          aggs: {
            metric: {
              [metric.aggregation]: {
                field: metric.field
              }
            }
          }
        }
      };
    }, {});
  }
  convertEquationToPainless(bucketsPath, equation) {
    const workingEquation = equation || Object.keys(bucketsPath).join(' + ');
    return Object.keys(bucketsPath).reduce((acc, key) => {
      return acc.replaceAll(key, `params.${key}`);
    }, workingEquation);
  }
  buildMetricEquation(type, metricDef) {
    const bucketsPath = metricDef.metrics.reduce((acc, metric) => {
      const path = _sloSchema.metricCustomDocCountMetric.is(metric) ? '_count' : 'metric';
      return {
        ...acc,
        [metric.name]: `_${type}_${metric.name}>${path}`
      };
    }, {});
    return {
      bucket_script: {
        buckets_path: bucketsPath,
        script: {
          source: this.convertEquationToPainless(bucketsPath, metricDef.equation),
          lang: 'painless'
        }
      }
    };
  }
  execute({
    type,
    aggregationKey
  }) {
    const indicatorDef = this.indicator.params[type];
    return {
      ...this.buildMetricAggregations(type, indicatorDef),
      [aggregationKey]: this.buildMetricEquation(type, indicatorDef)
    };
  }
}
exports.GetCustomMetricIndicatorAggregation = GetCustomMetricIndicatorAggregation;