"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLabel = exports.formatAlertResult = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../common/custom_threshold_rule/types");
var _formatters = require("../../../../../common/custom_threshold_rule/formatters");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLabel = criterion => {
  if (!criterion.label && criterion.metrics.length === 1) {
    switch (criterion.metrics[0].aggType) {
      case _types.Aggregators.COUNT:
        return _translations.DOCUMENT_COUNT_I18N;
      case _types.Aggregators.AVERAGE:
        return (0, _translations.AVERAGE_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.MAX:
        return (0, _translations.MAX_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.MIN:
        return (0, _translations.MIN_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.CARDINALITY:
        return (0, _translations.CARDINALITY_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.SUM:
        return (0, _translations.SUM_I18N)(criterion.metrics[0].field);
    }
  }
  return criterion.label || _translations.CUSTOM_EQUATION_I18N;
};
exports.getLabel = getLabel;
const formatAlertResult = evaluationResult => {
  const {
    metrics,
    currentValue,
    threshold,
    comparator
  } = evaluationResult;
  const noDataValue = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alerting.threshold.noDataFormattedValue', {
    defaultMessage: '[NO DATA]'
  });
  let formatter = (0, _formatters.createFormatter)('highPrecision');
  const label = getLabel(evaluationResult);
  if (metrics.length === 1 && metrics[0].field && metrics[0].field.endsWith('.pct')) {
    formatter = (0, _formatters.createFormatter)('percent');
  }
  return {
    ...evaluationResult,
    currentValue: currentValue !== null && currentValue !== undefined ? formatter(currentValue) : noDataValue,
    label: label || _translations.CUSTOM_EQUATION_I18N,
    threshold: Array.isArray(threshold) ? threshold.map(v => formatter(v)) : [formatter(threshold)],
    comparator
  };
};
exports.formatAlertResult = formatAlertResult;