"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTimerange = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createTimerange = (interval, timeframe, lastPeriodEnd) => {
  const end = (0, _moment.default)(timeframe.end).valueOf();
  let start = (0, _moment.default)(timeframe.start).valueOf();
  start = start - interval;

  // Use lastPeriodEnd - interval when it's less than start
  if (lastPeriodEnd && lastPeriodEnd - interval < start) {
    start = lastPeriodEnd - interval;
  }
  return {
    start,
    end
  };
};
exports.createTimerange = createTimerange;