"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  config: true,
  plugin: true,
  createOrUpdateIndex: true,
  createOrUpdateIndexTemplate: true,
  unwrapEsResponse: true,
  WrappedElasticsearchClientError: true,
  rangeQuery: true,
  kqlQuery: true,
  termQuery: true,
  termsQuery: true,
  getParsedFilterQuery: true,
  getInspectResponse: true,
  uiSettings: true
};
Object.defineProperty(exports, "WrappedElasticsearchClientError", {
  enumerable: true,
  get: function () {
    return _unwrap_es_response.WrappedElasticsearchClientError;
  }
});
exports.config = void 0;
Object.defineProperty(exports, "createOrUpdateIndex", {
  enumerable: true,
  get: function () {
    return _create_or_update_index.createOrUpdateIndex;
  }
});
Object.defineProperty(exports, "createOrUpdateIndexTemplate", {
  enumerable: true,
  get: function () {
    return _create_or_update_index_template.createOrUpdateIndexTemplate;
  }
});
Object.defineProperty(exports, "getInspectResponse", {
  enumerable: true,
  get: function () {
    return _get_inspect_response.getInspectResponse;
  }
});
Object.defineProperty(exports, "getParsedFilterQuery", {
  enumerable: true,
  get: function () {
    return _get_parsed_filtered_query.getParsedFilterQuery;
  }
});
Object.defineProperty(exports, "kqlQuery", {
  enumerable: true,
  get: function () {
    return _queries.kqlQuery;
  }
});
exports.plugin = void 0;
Object.defineProperty(exports, "rangeQuery", {
  enumerable: true,
  get: function () {
    return _queries.rangeQuery;
  }
});
Object.defineProperty(exports, "termQuery", {
  enumerable: true,
  get: function () {
    return _queries.termQuery;
  }
});
Object.defineProperty(exports, "termsQuery", {
  enumerable: true,
  get: function () {
    return _queries.termsQuery;
  }
});
Object.defineProperty(exports, "uiSettings", {
  enumerable: true,
  get: function () {
    return _ui_settings.uiSettings;
  }
});
Object.defineProperty(exports, "unwrapEsResponse", {
  enumerable: true,
  get: function () {
    return _unwrap_es_response.unwrapEsResponse;
  }
});
var _configSchema = require("@kbn/config-schema");
var _create_or_update_index = require("./utils/create_or_update_index");
var _create_or_update_index_template = require("./utils/create_or_update_index_template");
var _unwrap_es_response = require("../common/utils/unwrap_es_response");
var _queries = require("./utils/queries");
var _get_parsed_filtered_query = require("./utils/get_parsed_filtered_query");
var _get_inspect_response = require("../common/utils/get_inspect_response");
var _types = require("./types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
var _ui_settings = require("./ui_settings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */ // TODO: https://github.com/elastic/kibana/issues/110905
/* eslint-disable @kbn/eslint/no_export_all */
const configSchema = _configSchema.schema.object({
  annotations: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    }),
    index: _configSchema.schema.string({
      defaultValue: 'observability-annotations'
    })
  }),
  unsafe: _configSchema.schema.object({
    alertDetails: _configSchema.schema.object({
      metrics: _configSchema.schema.object({
        enabled: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      logs: _configSchema.schema.object({
        enabled: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      uptime: _configSchema.schema.object({
        enabled: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      observability: _configSchema.schema.object({
        enabled: _configSchema.schema.boolean({
          defaultValue: false
        })
      })
    }),
    thresholdRule: _configSchema.schema.object({
      enabled: (0, _configSchema.offeringBasedSchema)({
        serverless: _configSchema.schema.boolean({
          defaultValue: false
        }),
        traditional: _configSchema.schema.boolean({
          defaultValue: false
        })
      })
    })
  }),
  customThresholdRule: _configSchema.schema.object({
    groupByPageSize: _configSchema.schema.number({
      defaultValue: 10_000
    })
  }),
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  createO11yGenericFeatureId: _configSchema.schema.boolean({
    defaultValue: false
  })
});
const config = {
  exposeToBrowser: {
    unsafe: true,
    aiAssistant: {
      enabled: true,
      feedback: {
        enabled: true
      }
    }
  },
  schema: configSchema,
  deprecations: ({
    unused
  }) => [unused('unsafe.thresholdRule.enabled', {
    level: 'warning'
  }), unused('unsafe.alertDetails.logs.enabled', {
    level: 'warning'
  })]
};
exports.config = config;
const plugin = async initContext => {
  const {
    ObservabilityPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new ObservabilityPlugin(initContext);
};
exports.plugin = plugin;