"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_SLO_ALERTS_ACTION = void 0;
exports.createEditSloAlertsPanelAction = createEditSloAlertsPanelAction;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/embeddable-plugin/common");
var _constants = require("../embeddable/slo/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const EDIT_SLO_ALERTS_ACTION = 'editSloAlertsPanelAction';
exports.EDIT_SLO_ALERTS_ACTION = EDIT_SLO_ALERTS_ACTION;
function createEditSloAlertsPanelAction(getStartServices) {
  return {
    id: EDIT_SLO_ALERTS_ACTION,
    type: EDIT_SLO_ALERTS_ACTION,
    getIconType(context) {
      return 'pencil';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.observability.actions.editSloAlertsEmbeddableTitle', {
      defaultMessage: 'Edit configuration'
    }),
    async execute({
      embeddable
    }) {
      if (!embeddable) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      const [coreStart, pluginStart] = await getStartServices();
      try {
        const {
          resolveEmbeddableSloUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddable/slo/alerts/handle_explicit_input')));
        const result = await resolveEmbeddableSloUserInput(coreStart, pluginStart, embeddable.getInput());
        embeddable.updateInput(result);
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible({
      embeddable
    }) {
      return embeddable.type === _constants.SLO_ALERTS_EMBEDDABLE && embeddable.getInput().viewMode === _common.ViewMode.EDIT;
    }
  };
}