"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSloFormattedSummary = void 0;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _sloSchema = require("@kbn/slo-schema");
var _paths = require("../../../../common/locators/paths");
var _kibana_react = require("../../../utils/kibana_react");
var _i18n = require("../../../../common/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSloFormattedSummary = slo => {
  const {
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const sliValue = slo.summary.status === 'NO_DATA' ? _i18n.NOT_AVAILABLE_LABEL : (0, _numeral.default)(slo.summary.sliValue).format(percentFormat);
  const sloTarget = (0, _numeral.default)(slo.objective.target).format(percentFormat);
  const errorBudgetRemaining = slo.summary.errorBudget.remaining <= 0 ? Math.trunc(slo.summary.errorBudget.remaining * 100) / 100 : slo.summary.errorBudget.remaining;
  const errorBudgetRemainingTitle = slo.summary.status === 'NO_DATA' ? _i18n.NOT_AVAILABLE_LABEL : (0, _numeral.default)(errorBudgetRemaining).format(percentFormat);
  const sloDetailsUrl = basePath.prepend(_paths.paths.observability.sloDetails(slo.id, slo.groupBy !== _sloSchema.ALL_VALUE && slo.instanceId ? slo.instanceId : undefined));
  return {
    sloDetailsUrl,
    sliValue,
    sloTarget,
    errorBudgetRemaining: errorBudgetRemainingTitle
  };
};
exports.useSloFormattedSummary = useSloFormattedSummary;