"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRateRuleFlyout = BurnRateRuleFlyout;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _paths = require("../../../../../common/locators/paths");
var _use_get_filtered_rule_types = require("../../../../hooks/use_get_filtered_rule_types");
var _query_key_factory = require("../../../../hooks/slo/query_key_factory");
var _kibana_react = require("../../../../utils/kibana_react");
var _constants = require("../../../../../common/constants");
var _common = require("../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BurnRateRuleFlyout({
  slo,
  isAddRuleFlyoutOpen,
  canChangeTrigger,
  setIsAddRuleFlyoutOpen
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    triggersActionsUi: {
      getAddRuleFlyout: AddRuleFlyout
    }
  } = (0, _kibana_react.useKibana)().services;
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const handleSavedRule = async () => {
    if (setIsAddRuleFlyoutOpen) {
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.rules(),
        exact: false
      });
    } else {
      navigateToUrl(basePath.prepend(_paths.paths.observability.slos));
    }
  };
  const handleCloseRuleFlyout = async () => {
    if (setIsAddRuleFlyoutOpen) {
      setIsAddRuleFlyoutOpen(false);
    } else {
      navigateToUrl(basePath.prepend(_paths.paths.observability.slos));
    }
  };
  return isAddRuleFlyoutOpen && slo ? /*#__PURE__*/_react.default.createElement(AddRuleFlyout, {
    canChangeTrigger: canChangeTrigger,
    consumer: _common.sloFeatureId,
    filteredRuleTypes: filteredRuleTypes,
    ruleTypeId: _constants.SLO_BURN_RATE_RULE_TYPE_ID,
    initialValues: {
      name: `${slo.name} Burn Rate rule`,
      params: {
        sloId: slo.id
      }
    },
    onSave: handleSavedRule,
    onClose: handleCloseRuleFlyout,
    useRuleProducer: true
  }) : null;
}