"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloCardItemBadges = SloCardItemBadges;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _slo_badges = require("../badges/slo_badges");
var _slo_indicator_type_badge = require("../badges/slo_indicator_type_badge");
var _slo_time_window_badge = require("../badges/slo_time_window_badge");
var _slo_active_alerts_badge = require("../../../../components/slo/slo_status_badge/slo_active_alerts_badge");
var _slo_rules_badge = require("../badges/slo_rules_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _styledComponents.default.div`
  display: inline-block;
  margin-top: 5px;
`;
function SloCardItemBadges({
  slo,
  activeAlerts,
  rules,
  handleCreateRule
}) {
  return /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    wrap: true
  }, !slo.summary ? /*#__PURE__*/_react.default.createElement(_slo_badges.LoadingBadges, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_slo_active_alerts_badge.SloActiveAlertsBadge, {
    slo: slo,
    activeAlerts: activeAlerts,
    viewMode: "compact"
  }), /*#__PURE__*/_react.default.createElement(_slo_indicator_type_badge.SloIndicatorTypeBadge, {
    slo: slo,
    color: "default"
  }), /*#__PURE__*/_react.default.createElement(_slo_time_window_badge.SloTimeWindowBadge, {
    slo: slo,
    color: "default"
  }), /*#__PURE__*/_react.default.createElement(_slo_rules_badge.SloRulesBadge, {
    rules: rules,
    onClick: handleCreateRule
  }))));
}