"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloCardChart = SloCardChart;
exports.SloCardItem = SloCardItem;
exports.useSloCardColor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _sloSchema = require("@kbn/slo-schema");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _badges_portal = require("./badges_portal");
var _use_slo_list_actions = require("../../hooks/use_slo_list_actions");
var _burn_rate_rule_flyout = require("../common/burn_rate_rule_flyout");
var _chart_data_formatter = require("../../../../utils/slo/chart_data_formatter");
var _kibana_react = require("../../../../utils/kibana_react");
var _use_slo_summary = require("../../hooks/use_slo_summary");
var _slo_card_item_actions = require("./slo_card_item_actions");
var _slo_delete_confirmation_modal = require("../../../../components/slo/delete_confirmation_modal/slo_delete_confirmation_modal");
var _slo_card_item_badges = require("./slo_card_item_badges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSloCardColor = status => {
  const colors = {
    DEGRADING: (0, _eui.useEuiBackgroundColor)('warning'),
    VIOLATED: (0, _eui.useEuiBackgroundColor)('danger'),
    HEALTHY: (0, _eui.useEuiBackgroundColor)('success'),
    NO_DATA: (0, _eui.useEuiBackgroundColor)('subdued')
  };
  return colors[status !== null && status !== void 0 ? status : 'NO_DATA'];
};
exports.useSloCardColor = useSloCardColor;
const getSubTitle = slo => {
  return slo.groupBy && slo.groupBy !== _sloSchema.ALL_VALUE ? `${slo.groupBy}: ${slo.instanceId}` : '';
};
function SloCardItem({
  slo,
  rules,
  activeAlerts,
  historicalSummary,
  cardsPerRow
}) {
  const containerRef = _react.default.useRef(null);
  const [isMouseOver, setIsMouseOver] = (0, _react.useState)(false);
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react.useState)(false);
  const [isAddRuleFlyoutOpen, setIsAddRuleFlyoutOpen] = (0, _react.useState)(false);
  const [isDeleteConfirmationModalOpen, setDeleteConfirmationModalOpen] = (0, _react.useState)(false);
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(historicalSummary, 'sli_value');
  const {
    handleCreateRule,
    handleDeleteCancel,
    handleDeleteConfirm
  } = (0, _use_slo_list_actions.useSloListActions)({
    slo,
    setDeleteConfirmationModalOpen,
    setIsActionsPopoverOpen,
    setIsAddRuleFlyoutOpen
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    panelRef: containerRef,
    onMouseOver: () => {
      if (!isMouseOver) {
        setIsMouseOver(true);
      }
    },
    onMouseLeave: () => {
      if (isMouseOver) {
        setIsMouseOver(false);
      }
    },
    paddingSize: "none",
    css: (0, _react2.css)`
          height: 182px;
          overflow: hidden;
          position: relative;
        `,
    title: slo.summary.status
  }, /*#__PURE__*/_react.default.createElement(SloCardChart, {
    slo: slo,
    historicalSliData: historicalSliData
  }), (isMouseOver || isActionsPopoverOpen) && /*#__PURE__*/_react.default.createElement(_slo_card_item_actions.SloCardItemActions, {
    slo: slo,
    isActionsPopoverOpen: isActionsPopoverOpen,
    setIsActionsPopoverOpen: setIsActionsPopoverOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen,
    setDeleteConfirmationModalOpen: setDeleteConfirmationModalOpen
  })), /*#__PURE__*/_react.default.createElement(_badges_portal.SloCardBadgesPortal, {
    containerRef: containerRef
  }, /*#__PURE__*/_react.default.createElement(_slo_card_item_badges.SloCardItemBadges, {
    slo: slo,
    rules: rules,
    activeAlerts: activeAlerts,
    handleCreateRule: handleCreateRule,
    hasGroupBy: Boolean(slo.groupBy && slo.groupBy !== _sloSchema.ALL_VALUE)
  })), /*#__PURE__*/_react.default.createElement(_burn_rate_rule_flyout.BurnRateRuleFlyout, {
    slo: slo,
    isAddRuleFlyoutOpen: isAddRuleFlyoutOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen
  }), isDeleteConfirmationModalOpen ? /*#__PURE__*/_react.default.createElement(_slo_delete_confirmation_modal.SloDeleteConfirmationModal, {
    slo: slo,
    onCancel: handleDeleteCancel,
    onConfirm: handleDeleteConfirm
  }) : null);
}
function SloCardChart({
  slo,
  historicalSliData
}) {
  const {
    application: {
      navigateToUrl
    }
  } = (0, _kibana_react.useKibana)().services;
  const cardColor = useSloCardColor(slo.summary.status);
  const subTitle = getSubTitle(slo);
  const {
    sliValue,
    sloTarget,
    sloDetailsUrl
  } = (0, _use_slo_summary.useSloFormattedSummary)(slo);
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: _charts.DARK_THEME,
    onElementClick: ([d]) => {
      if ((0, _charts.isMetricElementEvent)(d)) {
        navigateToUrl(sloDetailsUrl);
      }
    },
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Metric, {
    id: `${slo.id}-${slo.instanceId}`,
    data: [[{
      title: slo.name,
      subtitle: subTitle,
      value: sliValue,
      trendShape: _charts.MetricTrendShape.Area,
      trend: historicalSliData === null || historicalSliData === void 0 ? void 0 : historicalSliData.map(d => ({
        x: d.key,
        y: d.value
      })),
      extra: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.sLOGridItem.targetFlexItemLabel",
        defaultMessage: "Target {target}",
        values: {
          target: sloTarget
        }
      }),
      icon: () => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "visGauge",
        size: "l"
      }),
      color: cardColor
    }]]
  }));
}