"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloRulesBadge = SloRulesBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloRulesBadge({
  rules,
  onClick
}) {
  return rules === undefined || rules.length > 0 ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.observability.slo.slo.rulesBadge.popover', {
      defaultMessage: 'There are no rules configured for this SLO yet. You will not receive alerts when SLO is breached.'
    }),
    display: "block"
  }, /*#__PURE__*/_react.default.createElement("span", {
    onClick: onClick,
    onKeyDown: onClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "text",
    iconType: "alert",
    css: {
      cursor: 'pointer'
    }
  })));
}