"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlosOutdatedDefinitions = SlosOutdatedDefinitions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _kibana_react = require("../../utils/kibana_react");
var _use_license = require("../../hooks/use_license");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_capabilities = require("../../hooks/slo/use_capabilities");
var _use_fetch_global_diagnosis = require("../../hooks/slo/use_fetch_global_diagnosis");
var _header_menu = require("../overview/components/header_menu/header_menu");
var _use_fetch_slo_definitions = require("../../hooks/slo/use_fetch_slo_definitions");
var _paths = require("../../../common/locators/paths");
var _slo_list_empty = require("../slos/components/slo_list_empty");
var _outdated_slo = require("./outdated_slo");
var _outdated_slo_search_bar = require("./outdated_slo_search_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SlosOutdatedDefinitions() {
  const {
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const {
    data: globalDiagnosis
  } = (0, _use_fetch_global_diagnosis.useFetchSloGlobalDiagnosis)();
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  (0, _public.useBreadcrumbs)([{
    href: basePath.prepend(_paths.paths.observability.slos),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.slosLinkText', {
      defaultMessage: 'SLOs'
    }),
    deepLinkId: 'observability-overview:slos'
  }, {
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.slosOutdatedDefinitions', {
      defaultMessage: 'Outdated SLO Definitions'
    })
  }]);
  const [search, setSearch] = (0, _react.useState)('');
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const [perPage, setPerPage] = (0, _react.useState)(10);
  const handlePerPageChange = perPageNumber => {
    setPerPage(perPageNumber);
    setActivePage(0);
  };
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const {
    isLoading,
    data,
    refetch
  } = (0, _use_fetch_slo_definitions.useFetchSloDefinitions)({
    name: search,
    includeOutdatedOnly: true,
    page: activePage + 1,
    perPage
  });
  const {
    total
  } = data !== null && data !== void 0 ? data : {
    total: 0
  };
  const hasRequiredWritePrivileges = !!(globalDiagnosis !== null && globalDiagnosis !== void 0 && globalDiagnosis.userPrivileges.write.has_all_requested) && hasWriteCapabilities;
  const hasPlatinumLicense = hasAtLeast('platinum') === true;
  const hasSlosAndHasPermissions = hasPlatinumLicense && hasRequiredWritePrivileges;
  const errors = !hasRequiredWritePrivileges ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.observability.slo.slosOutdatedDefinitions.sloPermissionsError', {
    defaultMessage: 'You must have write permissions for SLOs to access this page'
  })) : !hasPlatinumLicense ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.observability.slo.slosOutdatedDefinitions.licenseError', {
    defaultMessage: 'You must have atleast a platinum license to access this page'
  })) : null;
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "slosOutdatedDefinitions",
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.observability.slo.slosOutdatedDefinitions.pageTitle', {
        defaultMessage: 'Outdated SLO Definitions'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), !hasSlosAndHasPermissions ? errors : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability.slo.slosOutdatedDefinitions.description', {
    defaultMessage: 'The following SLOs are from a previous version and need to either be reset to upgrade to the latest version OR deleted and removed from the system. When you reset the SLO, the transform will be updated to the latest version and the historical data will be regenerated from the source data.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_outdated_slo_search_bar.OutdatedSloSearchBar, {
    initialSearch: search,
    onRefresh: refetch,
    onSearch: setSearch
  })), !isLoading && total === 0 && /*#__PURE__*/_react.default.createElement(_slo_list_empty.SloListEmpty, null), !isLoading && total > 0 && data && data.results.map(slo => /*#__PURE__*/_react.default.createElement(_outdated_slo.OutdatedSlo, {
    slo: slo,
    onDelete: refetch,
    onReset: refetch
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !isLoading && data && /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    activePage: activePage,
    pageCount: Math.ceil(total / perPage),
    itemsPerPage: perPage,
    onChangePage: setActivePage,
    onChangeItemsPerPage: handlePerPageChange,
    itemsPerPageOptions: [10, 20, 50, 100]
  })));
}