"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistogramIndicatorTypeForm = HistogramIndicatorTypeForm;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/slo-schema/src/schema/common");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_fetch_index_pattern_fields = require("../../../../hooks/slo/use_fetch_index_pattern_fields");
var _data_preview_chart = require("../common/data_preview_chart");
var _index_field_selector = require("../common/index_field_selector");
var _query_builder = require("../common/query_builder");
var _index_selection = require("../custom_common/index_selection");
var _histogram_indicator = require("./histogram_indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HistogramIndicatorTypeForm() {
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const index = watch('indicator.params.index');
  const {
    isLoading: isIndexFieldsLoading,
    data: indexFields = []
  } = (0, _use_fetch_index_pattern_fields.useFetchIndexPatternFields)(index);
  const histogramFields = indexFields.filter(field => field.type === 'histogram');
  const timestampFields = indexFields.filter(field => field.type === 'date');
  const groupByFields = indexFields.filter(field => field.aggregatable);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.slo.sloEdit.sliType.histogram.sourceTitle",
    defaultMessage: "Source"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_index_selection.IndexSelection, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_index_field_selector.IndexFieldSelector, {
    indexFields: timestampFields,
    name: "indicator.params.timestampField",
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timestampField.label', {
      defaultMessage: 'Timestamp field'
    }),
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timestampField.placeholder', {
      defaultMessage: 'Select a timestamp field'
    }),
    isLoading: !!index && isIndexFieldsLoading,
    isDisabled: !index,
    isRequired: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "histogramIndicatorFormQueryFilterInput",
    indexPatternString: watch('indicator.params.index'),
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.queryFilter', {
      defaultMessage: 'Query filter'
    }),
    name: "indicator.params.filter",
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.customFilter', {
      defaultMessage: 'Custom filter to apply on the index'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.customFilter.tooltip', {
        defaultMessage: 'This KQL query can be used to filter the documents with some relevant criteria.'
      }),
      position: "top"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.slo.sloEdit.sliType.histogram.goodTitle",
    defaultMessage: "Good events"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_histogram_indicator.HistogramIndicator, {
    type: "good",
    histogramFields: histogramFields,
    isLoadingIndex: isIndexFieldsLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.slo.sloEdit.sliType.histogram.totalTitle",
    defaultMessage: "Total events"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_histogram_indicator.HistogramIndicator, {
    type: "total",
    histogramFields: histogramFields,
    isLoadingIndex: isIndexFieldsLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_index_field_selector.IndexFieldSelector, {
    indexFields: groupByFields,
    name: "groupBy",
    defaultValue: _common.ALL_VALUE,
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloEdit.groupBy.label', {
      defaultMessage: 'Group by'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.groupBy.tooltip', {
        defaultMessage: 'Create individual SLOs for each value of the selected field.'
      }),
      position: "top"
    })),
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.groupBy.placeholder', {
      defaultMessage: 'Select an optional field to group by'
    }),
    isLoading: !!index && isIndexFieldsLoading,
    isDisabled: !index
  }), /*#__PURE__*/_react.default.createElement(_data_preview_chart.DataPreviewChart, null)));
}