"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexFieldSelector = IndexFieldSelector;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _create_options = require("../../helpers/create_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IndexFieldSelector({
  indexFields,
  name,
  label,
  placeholder,
  isDisabled,
  isLoading,
  isRequired = false,
  defaultValue = ''
}) {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const [options, setOptions] = (0, _react.useState)((0, _create_options.createOptionsFromFields)(indexFields));
  (0, _react.useEffect)(() => {
    setOptions((0, _create_options.createOptionsFromFields)(indexFields));
  }, [indexFields]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    isInvalid: getFieldState(name).invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: defaultValue,
    name: name,
    control: control,
    rules: {
      required: isRequired && !isDisabled
    },
    render: ({
      field,
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      async: true,
      placeholder: placeholder,
      "aria-label": placeholder,
      isClearable: true,
      isDisabled: isLoading || isDisabled,
      isInvalid: fieldState.invalid,
      isLoading: isLoading,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange(defaultValue);
      },
      options: options,
      onSearchChange: searchValue => {
        setOptions((0, _create_options.createOptionsFromFields)(indexFields, ({
          value
        }) => value.includes(searchValue)));
      },
      selectedOptions: !!indexFields && !!field.value && indexFields.some(indexField => indexField.name === field.value) ? [{
        value: field.value,
        label: field.value
      }] : [],
      singleSelection: true
    }))
  })));
}