"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDetailsPage = SloDetailsPage;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactQuery = require("@tanstack/react-query");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _kibana_react = require("../../utils/kibana_react");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_fetch_slo_details = require("../../hooks/slo/use_fetch_slo_details");
var _use_license = require("../../hooks/use_license");
var _ = _interopRequireDefault(require("../404"));
var _slo_details = require("./components/slo_details");
var _header_title = require("./components/header_title");
var _header_control = require("./components/header_control");
var _paths = require("../../../common/locators/paths");
var _auto_refresh_button = require("../../components/slo/auto_refresh_button");
var _feedback_button = require("../../components/slo/feedback_button/feedback_button");
var _use_get_instance_id_query_param = require("./hooks/use_get_instance_id_query_param");
var _use_auto_refresh_storage = require("../../components/slo/auto_refresh_button/hooks/use_auto_refresh_storage");
var _header_menu = require("../overview/components/header_menu/header_menu");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloDetailsPage() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const hasRightLicense = hasAtLeast('platinum');
  const {
    sloId
  } = (0, _reactRouterDom.useParams)();
  const sloInstanceId = (0, _use_get_instance_id_query_param.useGetInstanceIdQueryParam)();
  const {
    storeAutoRefreshState,
    getAutoRefreshState
  } = (0, _use_auto_refresh_storage.useAutoRefreshStorage)();
  const [isAutoRefreshing, setIsAutoRefreshing] = (0, _react.useState)(getAutoRefreshState());
  const {
    isLoading,
    data: slo
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId,
    instanceId: sloInstanceId,
    shouldRefetch: isAutoRefreshing
  });
  const isCloningOrDeleting = Boolean((0, _reactQuery.useIsMutating)());
  (0, _public.useBreadcrumbs)(getBreadcrumbs(basePath, slo));
  const isSloNotFound = !isLoading && slo === undefined;
  if (isSloNotFound) {
    return /*#__PURE__*/_react.default.createElement(_.default, null);
  }
  if (hasRightLicense === false) {
    navigateToUrl(basePath.prepend(_paths.paths.observability.slos));
  }
  const isPerformingAction = isLoading || isCloningOrDeleting;
  const handleToggleAutoRefresh = () => {
    setIsAutoRefreshing(!isAutoRefreshing);
    storeAutoRefreshState(!isAutoRefreshing);
  };
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_header_title.HeaderTitle, {
        isLoading: isPerformingAction,
        slo: slo
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_header_control.HeaderControl, {
        isLoading: isPerformingAction,
        slo: slo
      }), /*#__PURE__*/_react.default.createElement(_auto_refresh_button.AutoRefreshButton, {
        disabled: isPerformingAction,
        isAutoRefreshing: isAutoRefreshing,
        onClick: handleToggleAutoRefresh
      }), /*#__PURE__*/_react.default.createElement(_feedback_button.FeedbackButton, {
        disabled: isPerformingAction
      })],
      bottomBorder: false
    },
    "data-test-subj": "sloDetailsPage"
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "sloDetailsLoading"
  }), !isLoading && /*#__PURE__*/_react.default.createElement(_slo_details.SloDetails, {
    slo: slo,
    isAutoRefreshing: isAutoRefreshing
  }));
}
function getBreadcrumbs(basePath, slo) {
  var _slo$name;
  return [{
    href: basePath.prepend(_paths.paths.observability.slos),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.slosLinkText', {
      defaultMessage: 'SLOs'
    }),
    deepLinkId: 'observability-overview:slos'
  }, {
    text: (_slo$name = slo === null || slo === void 0 ? void 0 : slo.name) !== null && _slo$name !== void 0 ? _slo$name : _i18n.i18n.translate('xpack.observability.breadcrumbs.sloDetailsLinkText', {
      defaultMessage: 'Details'
    })
  }];
}