"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingCallout = ObservabilityOnboardingCallout;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _use_observability_onboarding = require("../../../hooks/use_observability_onboarding");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ObservabilityOnboardingCallout() {
  const {
    application
  } = (0, _public.useKibana)().services;
  const trackMetric = (0, _public2.useUiTracker)({
    app: 'observability-overview'
  });
  const {
    isObservabilityOnboardingDismissed,
    dismissObservabilityOnboarding
  } = (0, _use_observability_onboarding.useObservabilityOnboarding)();
  const dismissOnboarding = (0, _react.useCallback)(() => {
    dismissObservabilityOnboarding();
    trackMetric({
      metric: 'observability_onboarding_dismiss'
    });
  }, [dismissObservabilityOnboarding, trackMetric]);
  const getStarted = () => {
    trackMetric({
      metric: 'observability_onboarding_get_started'
    });
    application === null || application === void 0 ? void 0 : application.navigateToApp('observabilityOnboarding');
  };
  return !isObservabilityOnboardingDismissed ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "primary",
    "data-test-subj": "observability-onboarding-callout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.overview.observabilityOnboarding",
    defaultMessage: "Collect and analyze logs in observability"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.overview.observabilityOnboarding.description",
    defaultMessage: "Onboard your data in up to 5 minutes to start analysing it straight away."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    direction: "row",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11yObservabilityOnboardingDismissButton",
    size: "s",
    onClick: dismissOnboarding
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.overview.observabilityOnboarding.dismiss",
    defaultMessage: "Dismiss"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yObservabilityOnboardingGetStartedButton",
    size: "s",
    onClick: getStarted
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.overview.observabilityOnboarding.getStarted",
    defaultMessage: "Get started"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null;
}