"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseFeatureNoPermissions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _empty_page = require("./empty_page");
var _kibana_react = require("../../../utils/kibana_react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseFeatureNoPermissions = /*#__PURE__*/_react.default.memo(() => {
  const {
    docLinks
  } = (0, _kibana_react.useKibana)().services;
  const actions = (0, _react.useMemo)(() => ({
    savedObject: {
      icon: 'documents',
      label: _i18n.i18n.translate('xpack.observability.cases.caseView.goToDocumentationButton', {
        defaultMessage: 'View documentation'
      }),
      target: '_blank',
      url: `${docLinks.ELASTIC_WEBSITE_URL}guide/en/security/${docLinks.DOC_LINK_VERSION}s`
    }
  }), [docLinks]);
  return /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, {
    actions: actions,
    "data-test-subj": "noFeaturePermissions",
    message: _i18n.i18n.translate('xpack.observability.cases.caseFeatureNoPermissionsMessage', {
      defaultMessage: 'To view cases, you must have privileges for the Cases feature in the Kibana space. For more information, contact your Kibana administrator.'
    }),
    title: _i18n.i18n.translate('xpack.observability.cases.caseFeatureNoPermissionsTitle', {
      defaultMessage: 'Kibana feature privileges required'
    })
  });
});
exports.CaseFeatureNoPermissions = CaseFeatureNoPermissions;
CaseFeatureNoPermissions.displayName = 'CaseSavedObjectNoPermissions';