"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloDefinitions = useFetchSloDefinitions;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../../utils/kibana_react");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloDefinitions({
  name = '',
  includeOutdatedOnly = false,
  page = 1,
  perPage = 100
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const search = name.endsWith('*') ? name : `${name}*`;
  const {
    isLoading,
    isError,
    isSuccess,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.definitions(search, page, perPage, includeOutdatedOnly),
    queryFn: async ({
      signal
    }) => {
      try {
        const response = await http.get('/api/observability/slos/_definitions', {
          query: {
            search,
            includeOutdatedOnly,
            page,
            perPage
          },
          signal
        });
        return response;
      } catch (error) {
        throw new Error(`Something went wrong. Error: ${error}`);
      }
    },
    retry: false,
    refetchOnWindowFocus: false
  });
  return {
    isLoading,
    isError,
    isSuccess,
    data,
    refetch
  };
}