"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloAlertsTable = SloAlertsTable;
exports.useSloAlertsQuery = exports.getSloInstanceFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _sloSchema = require("@kbn/slo-schema");
var _constants = require("../../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_PER_PAGE = 10;
const ALERTS_TABLE_ID = 'xpack.observability.sloAlertsEmbeddable.alert.table';
const getSloInstanceFilter = (sloId, sloInstanceId) => {
  return {
    bool: {
      must: [{
        term: {
          'slo.id': sloId
        }
      }, ...(sloInstanceId !== _sloSchema.ALL_VALUE ? [{
        term: {
          'slo.instanceId': sloInstanceId
        }
      }] : [])]
    }
  };
};
exports.getSloInstanceFilter = getSloInstanceFilter;
const useSloAlertsQuery = (slos, timeRange) => {
  return (0, _react.useMemo)(() => {
    const query = {
      bool: {
        filter: [{
          range: {
            '@timestamp': {
              gte: timeRange.from
            }
          }
        }, {
          term: {
            'kibana.alert.rule.rule_type_id': 'slo.rules.burnRate'
          }
        }, {
          bool: {
            should: slos.map(slo => getSloInstanceFilter(slo.id, slo.instanceId))
          }
        }]
      }
    };
    return query;
  }, [slos, timeRange]);
};
exports.useSloAlertsQuery = useSloAlertsQuery;
function SloAlertsTable({
  slos,
  deps,
  timeRange,
  onLoaded,
  lastReloadRequestTime
}) {
  const {
    triggersActionsUi: {
      alertsTableConfigurationRegistry,
      getAlertsStateTable: AlertsStateTable
    }
  } = deps;
  return /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
    query: useSloAlertsQuery(slos, timeRange),
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    configurationId: _constants.SLO_ALERTS_TABLE_CONFID,
    featureIds: [_ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.OBSERVABILITY],
    hideLazyLoader: true,
    id: ALERTS_TABLE_ID,
    pageSize: ALERTS_PER_PAGE,
    showAlertStatusWithFlapping: true,
    onLoaded: () => {
      if (onLoaded) {
        onLoaded();
      }
    },
    lastReloadRequestTime: lastReloadRequestTime
  });
}