"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloGroupByBadge = SloGroupByBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloGroupByBadge({
  slo,
  color
}) {
  if (!slo.groupBy || slo.groupBy === _sloSchema.ALL_VALUE) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color !== null && color !== void 0 ? color : _uiTheme.euiLightVars.euiColorDisabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.observability.slo.groupByBadge', {
      defaultMessage: 'Group by {groupKey}',
      values: {
        groupKey: slo.groupBy
      }
    }),
    display: "block"
  }, /*#__PURE__*/_react.default.createElement("span", null, slo.groupBy, ": ", slo.instanceId))));
}