"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeRangeRT = exports.metricsExplorerSeriesRT = exports.metricsExplorerRowRT = exports.metricsExplorerResponseRT = exports.metricsExplorerPageInfoRT = exports.metricsExplorerMetricRT = exports.metricsExplorerColumnTypeRT = exports.metricsExplorerColumnRT = exports.expressionTimestampsRT = exports.expressionOptionsRT = exports.afterKeyObjectRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _types = require("../../../common/custom_threshold_rule/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const expressionTimestampsRT = rt.type({
  fromTimestamp: rt.number,
  toTimestamp: rt.number,
  interval: rt.string,
  timeFieldName: rt.string
});
exports.expressionTimestampsRT = expressionTimestampsRT;
/*
 * Expression options
 */
const metricsExplorerMetricRT = rt.intersection([rt.type({
  name: rt.string,
  aggregation: _types.aggType
}), rt.partial({
  field: rt.string,
  filter: rt.string
})]);
exports.metricsExplorerMetricRT = metricsExplorerMetricRT;
const customThresholdExpressionMetricRT = rt.intersection([rt.type({
  aggregation: rt.string
}), rt.partial({
  field: rt.union([rt.string, rt.undefined]),
  custom_metrics: rt.array(metricsExplorerMetricRT),
  equation: rt.string
})]);
const expressionOptionsRT = rt.intersection([rt.type({
  aggregation: rt.string,
  metrics: rt.array(customThresholdExpressionMetricRT)
}), rt.partial({
  limit: rt.number,
  groupBy: rt.union([rt.string, rt.array(rt.string)]),
  filterQuery: rt.string,
  source: rt.string,
  forceInterval: rt.boolean,
  dropLastBucket: rt.boolean
})]);
exports.expressionOptionsRT = expressionOptionsRT;
/*
 * End of expression options
 */

/*
 * Metrics explorer types
 */
const timeRangeRT = rt.type({
  from: rt.number,
  to: rt.number,
  interval: rt.string
});
exports.timeRangeRT = timeRangeRT;
const afterKeyObjectRT = rt.record(rt.string, rt.union([rt.string, rt.null]));
exports.afterKeyObjectRT = afterKeyObjectRT;
const metricsExplorerPageInfoRT = rt.type({
  total: rt.number,
  afterKey: rt.union([rt.string, rt.null, afterKeyObjectRT])
});
exports.metricsExplorerPageInfoRT = metricsExplorerPageInfoRT;
const metricsExplorerColumnTypeRT = rt.keyof({
  date: null,
  number: null,
  string: null
});
exports.metricsExplorerColumnTypeRT = metricsExplorerColumnTypeRT;
const metricsExplorerColumnRT = rt.type({
  name: rt.string,
  type: metricsExplorerColumnTypeRT
});
exports.metricsExplorerColumnRT = metricsExplorerColumnRT;
const metricsExplorerRowRT = rt.intersection([rt.type({
  timestamp: rt.number
}), rt.record(rt.string, rt.union([rt.string, rt.number, rt.null, rt.undefined, rt.array(rt.object)]))]);
exports.metricsExplorerRowRT = metricsExplorerRowRT;
const metricsExplorerSeriesRT = rt.intersection([rt.type({
  id: rt.string,
  columns: rt.array(metricsExplorerColumnRT),
  rows: rt.array(metricsExplorerRowRT)
}), rt.partial({
  keys: rt.array(rt.string)
})]);
exports.metricsExplorerSeriesRT = metricsExplorerSeriesRT;
const metricsExplorerResponseRT = rt.type({
  series: rt.array(metricsExplorerSeriesRT),
  pageInfo: metricsExplorerPageInfoRT
});

/*
 * End of metrics explorer types
 */
exports.metricsExplorerResponseRT = metricsExplorerResponseRT;